# Serialized Data (Fields Only)

This document is a list of all the OpenTimelineIO classes that serialize to and
from JSON, omitting plugins classes and docstrings.

This document is automatically generated by running:

`src/py-opentimelineio/opentimelineio/console/autogen_serialized_datamodel.py`

or by running:

`make doc-model`

It is part of the unit tests suite and should be updated whenever the schema
changes.  If it needs to be updated and this file regenerated, run:

`make doc-model-update`


# Classes


## Module: opentimelineio.adapters

### Adapter.1

parameters:
- *filepath*
- *name*
- *suffixes*

## Module: opentimelineio.core

### Color.1

parameters:
- *a*
- *b*
- *g*
- *name*
- *r*

### Composable.1

parameters:
- *metadata*
- *name*

### Composition.1

parameters:
- *color*
- *effects*
- *enabled*
- *markers*
- *metadata*
- *name*
- *source_range*

### Item.1

parameters:
- *color*
- *effects*
- *enabled*
- *markers*
- *metadata*
- *name*
- *source_range*

### MediaReference.1

parameters:
- *available_image_bounds*
- *available_range*
- *metadata*
- *name*

### SerializableObjectWithMetadata.1

parameters:
- *metadata*
- *name*

## Module: opentimelineio.hooks

### HookScript.1

parameters:
- *filepath*
- *name*

## Module: opentimelineio.media_linker

### MediaLinker.1

parameters:
- *filepath*
- *name*

## Module: opentimelineio.opentime

### RationalTime.1

parameters:
- *rate*
- *value*

### TimeRange.1

parameters:
- *duration*
- *start_time*

### TimeTransform.1

parameters:
- *offset*
- *rate*
- *scale*

## Module: opentimelineio.plugins

### PluginManifest.1

parameters:
- *adapters*
- *hook_scripts*
- *hooks*
- *media_linkers*
- *schemadefs*
- *version_manifests*

### SerializableObject.1

parameters:
- *filepath*
- *name*

## Module: opentimelineio.schema

### Clip.2

parameters:
- *active_media_reference_key*
- *color*
- *effects*
- *enabled*
- *markers*
- *media_references*
- *metadata*
- *name*
- *source_range*

### Effect.1

parameters:
- *effect_name*
- *enabled*
- *metadata*
- *name*

### ExternalReference.1

parameters:
- *available_image_bounds*
- *available_range*
- *metadata*
- *name*
- *target_url*

### FreezeFrame.1

parameters:
- *effect_name*
- *enabled*
- *metadata*
- *name*
- *time_scalar*

### Gap.1

parameters:
- *color*
- *effects*
- *enabled*
- *markers*
- *metadata*
- *name*
- *source_range*

### GeneratorReference.1

parameters:
- *available_image_bounds*
- *available_range*
- *generator_kind*
- *metadata*
- *name*
- *parameters*

### ImageSequenceReference.1

parameters:
- *available_image_bounds*
- *available_range*
- *frame_step*
- *frame_zero_padding*
- *metadata*
- *missing_frame_policy*
- *name*
- *name_prefix*
- *name_suffix*
- *rate*
- *start_frame*
- *target_url_base*

### LinearTimeWarp.1

parameters:
- *effect_name*
- *enabled*
- *metadata*
- *name*
- *time_scalar*

### Marker.2

parameters:
- *color*
- *comment*
- *marked_range*
- *metadata*
- *name*

### MissingReference.1

parameters:
- *available_image_bounds*
- *available_range*
- *metadata*
- *name*

### SerializableCollection.1

parameters:
- *metadata*
- *name*

### Stack.1

parameters:
- *color*
- *effects*
- *enabled*
- *markers*
- *metadata*
- *name*
- *source_range*

### TimeEffect.1

parameters:
- *effect_name*
- *enabled*
- *metadata*
- *name*

### Timeline.1

parameters:
- *global_start_time*
- *metadata*
- *name*
- *tracks*

### Track.1

parameters:
- *color*
- *effects*
- *enabled*
- *kind*
- *markers*
- *metadata*
- *name*
- *source_range*

### Transition.1

parameters:
- *in_offset*
- *metadata*
- *name*
- *out_offset*
- *transition_type*

### SchemaDef.1

parameters:
- *filepath*
- *name*
