// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{EulerOrder, Matrix, Quaternion, Vec3, ffi};
use glib::translate::*;

glib::wrapper! {
    pub struct Euler(BoxedInline<ffi::graphene_euler_t>);

    match fn {
        copy => |ptr| glib::gobject_ffi::g_boxed_copy(ffi::graphene_euler_get_type(), ptr as *mut _) as *mut ffi::graphene_euler_t,
        free => |ptr| glib::gobject_ffi::g_boxed_free(ffi::graphene_euler_get_type(), ptr as *mut _),
        type_ => || ffi::graphene_euler_get_type(),
    }
}

impl Euler {
    #[doc(alias = "graphene_euler_equal")]
    fn equal(&self, b: &Euler) -> bool {
        unsafe { ffi::graphene_euler_equal(self.to_glib_none().0, b.to_glib_none().0) }
    }

    #[doc(alias = "graphene_euler_get_alpha")]
    #[doc(alias = "get_alpha")]
    pub fn alpha(&self) -> f32 {
        unsafe { ffi::graphene_euler_get_alpha(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_euler_get_beta")]
    #[doc(alias = "get_beta")]
    pub fn beta(&self) -> f32 {
        unsafe { ffi::graphene_euler_get_beta(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_euler_get_gamma")]
    #[doc(alias = "get_gamma")]
    pub fn gamma(&self) -> f32 {
        unsafe { ffi::graphene_euler_get_gamma(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_euler_get_order")]
    #[doc(alias = "get_order")]
    pub fn order(&self) -> EulerOrder {
        unsafe { from_glib(ffi::graphene_euler_get_order(self.to_glib_none().0)) }
    }

    #[doc(alias = "graphene_euler_get_x")]
    #[doc(alias = "get_x")]
    pub fn x(&self) -> f32 {
        unsafe { ffi::graphene_euler_get_x(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_euler_get_y")]
    #[doc(alias = "get_y")]
    pub fn y(&self) -> f32 {
        unsafe { ffi::graphene_euler_get_y(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_euler_get_z")]
    #[doc(alias = "get_z")]
    pub fn z(&self) -> f32 {
        unsafe { ffi::graphene_euler_get_z(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_euler_reorder")]
    #[must_use]
    pub fn reorder(&self, order: EulerOrder) -> Euler {
        unsafe {
            let mut res = Euler::uninitialized();
            ffi::graphene_euler_reorder(
                self.to_glib_none().0,
                order.into_glib(),
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_euler_to_matrix")]
    pub fn to_matrix(&self) -> Matrix {
        unsafe {
            let mut res = Matrix::uninitialized();
            ffi::graphene_euler_to_matrix(self.to_glib_none().0, res.to_glib_none_mut().0);
            res
        }
    }

    #[doc(alias = "graphene_euler_to_quaternion")]
    pub fn to_quaternion(&self) -> Quaternion {
        unsafe {
            let mut res = Quaternion::uninitialized();
            ffi::graphene_euler_to_quaternion(self.to_glib_none().0, res.to_glib_none_mut().0);
            res
        }
    }

    #[doc(alias = "graphene_euler_to_vec3")]
    pub fn to_vec3(&self) -> Vec3 {
        unsafe {
            let mut res = Vec3::uninitialized();
            ffi::graphene_euler_to_vec3(self.to_glib_none().0, res.to_glib_none_mut().0);
            res
        }
    }
}

impl PartialEq for Euler {
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        self.equal(other)
    }
}

impl Eq for Euler {}
