#include <stdio.h>
#include <string>

struct DivByZero {
  std::string filename_;
  int line_;
};

int main () {
  printf ("DivByZero: Make sure that no division by zero happens\n");
  printf ("=====================================================\n");
  try {
    int a = 3, b = 2, t = -6;
    int f = (a-b) / (3+t/b);
  } catch (DivByZero &exc) {
    printf("That's it! -> see %s:%d\n", exc.filename_.c_str(), exc.line_);
  }
  printf ("=====================================================\n");
}


// catch division by zero error before they occur
aspect DivByZeroCheck {

  advice builtin("% operator / (%,%)") && args(numerator, denominator) :
  before (int numerator, int denominator) {
      printf ("before division: %d / %d\n", numerator, denominator);
      if (denominator == 0)
        throw DivByZero { JoinPoint::filename(), JoinPoint::line() };
  }

};
