// Copyright 2018 The Bazel Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v5.28.1
// source: build/bazel/remote/execution/v2/remote_execution.proto

package remoteexecution

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Execution_Execute_FullMethodName       = "/build.bazel.remote.execution.v2.Execution/Execute"
	Execution_WaitExecution_FullMethodName = "/build.bazel.remote.execution.v2.Execution/WaitExecution"
)

// ExecutionClient is the client API for Execution service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExecutionClient interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, the
	// [Command][build.bazel.remote.execution.v2.Command] to run, and the
	// [Action][build.bazel.remote.execution.v2.Action] into the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	// It then calls `Execute` with an `action_digest` referring to them. The
	// server will run the action and eventually return the result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a stream of
	// [google.longrunning.Operation][google.longrunning.Operation] messages
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][build.bazel.remote.execution.v2.ExecuteResponse]. The
	// `metadata` on the operation is of type
	// [ExecuteOperationMetadata][build.bazel.remote.execution.v2.ExecuteOperationMetadata].
	//
	// If the client remains connected after the first response is returned after
	// the server, then updates are streamed as if the client had called
	// [WaitExecution][build.bazel.remote.execution.v2.Execution.WaitExecution]
	// until the execution completes or the request reaches an error. The
	// operation can also be queried using [Operations
	// API][google.longrunning.Operations.GetOperation].
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operations API.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// action will be reported in the `status` field of the `ExecuteResponse`. The
	// server MUST NOT set the `error` field of the `Operation` proto.
	// The possible errors include:
	//
	//   - `INVALID_ARGUMENT`: One or more arguments are invalid.
	//   - `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//     action requested, such as a missing input or command or no worker being
	//     available. The client may be able to fix the errors and retry.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//     the action.
	//   - `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//     occupied (and the server does not support a queue), the action could not
	//     be started. The client should retry.
	//   - `INTERNAL`: An internal error occurred in the execution engine or the
	//     worker.
	//   - `DEADLINE_EXCEEDED`: The execution timed out.
	//   - `CANCELLED`: The operation was cancelled by the client. This status is
	//     only possible if the server implements the Operations API CancelOperation
	//     method, and it was called for the current execution.
	//
	// In the case of a missing input or command, the server SHOULD additionally
	// send a [PreconditionFailure][google.rpc.PreconditionFailure] error detail
	// where, for each requested blob not present in the CAS, there is a
	// `Violation` with a `type` of `MISSING` and a `subject` of
	// `"blobs/{digest_function/}{hash}/{size}"` indicating the digest of the
	// missing blob. The `subject` is formatted the same way as the
	// `resource_name` provided to
	// [ByteStream.Read][google.bytestream.ByteStream.Read], with the leading
	// instance name omitted. `digest_function` MUST thus be omitted if its value
	// is one of MD5, MURMUR3, SHA1, SHA256, SHA384, SHA512, or VSO.
	//
	// The server does not need to guarantee that a call to this method leads to
	// at most one execution of the action. The server MAY execute the action
	// multiple times, potentially in parallel. These redundant executions MAY
	// continue to run, even if the operation is completed.
	Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (Execution_ExecuteClient, error)
	// Wait for an execution operation to complete. When the client initially
	// makes the request, the server immediately responds with the current status
	// of the execution. The server will leave the request stream open until the
	// operation completes, and then respond with the completed operation. The
	// server MAY choose to stream additional updates as execution progresses,
	// such as to provide an update as to the state of the execution.
	//
	// In addition to the cases describe for Execute, the WaitExecution method
	// may fail as follows:
	//
	//   - `NOT_FOUND`: The operation no longer exists due to any of a transient
	//     condition, an unknown operation name, or if the server implements the
	//     Operations API DeleteOperation method and it was called for the current
	//     execution. The client should call `Execute` to retry.
	WaitExecution(ctx context.Context, in *WaitExecutionRequest, opts ...grpc.CallOption) (Execution_WaitExecutionClient, error)
}

type executionClient struct {
	cc grpc.ClientConnInterface
}

func NewExecutionClient(cc grpc.ClientConnInterface) ExecutionClient {
	return &executionClient{cc}
}

func (c *executionClient) Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (Execution_ExecuteClient, error) {
	stream, err := c.cc.NewStream(ctx, &Execution_ServiceDesc.Streams[0], Execution_Execute_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &executionExecuteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Execution_ExecuteClient interface {
	Recv() (*longrunningpb.Operation, error)
	grpc.ClientStream
}

type executionExecuteClient struct {
	grpc.ClientStream
}

func (x *executionExecuteClient) Recv() (*longrunningpb.Operation, error) {
	m := new(longrunningpb.Operation)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *executionClient) WaitExecution(ctx context.Context, in *WaitExecutionRequest, opts ...grpc.CallOption) (Execution_WaitExecutionClient, error) {
	stream, err := c.cc.NewStream(ctx, &Execution_ServiceDesc.Streams[1], Execution_WaitExecution_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &executionWaitExecutionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Execution_WaitExecutionClient interface {
	Recv() (*longrunningpb.Operation, error)
	grpc.ClientStream
}

type executionWaitExecutionClient struct {
	grpc.ClientStream
}

func (x *executionWaitExecutionClient) Recv() (*longrunningpb.Operation, error) {
	m := new(longrunningpb.Operation)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ExecutionServer is the server API for Execution service.
// All implementations should embed UnimplementedExecutionServer
// for forward compatibility
type ExecutionServer interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, the
	// [Command][build.bazel.remote.execution.v2.Command] to run, and the
	// [Action][build.bazel.remote.execution.v2.Action] into the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	// It then calls `Execute` with an `action_digest` referring to them. The
	// server will run the action and eventually return the result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a stream of
	// [google.longrunning.Operation][google.longrunning.Operation] messages
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][build.bazel.remote.execution.v2.ExecuteResponse]. The
	// `metadata` on the operation is of type
	// [ExecuteOperationMetadata][build.bazel.remote.execution.v2.ExecuteOperationMetadata].
	//
	// If the client remains connected after the first response is returned after
	// the server, then updates are streamed as if the client had called
	// [WaitExecution][build.bazel.remote.execution.v2.Execution.WaitExecution]
	// until the execution completes or the request reaches an error. The
	// operation can also be queried using [Operations
	// API][google.longrunning.Operations.GetOperation].
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operations API.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// action will be reported in the `status` field of the `ExecuteResponse`. The
	// server MUST NOT set the `error` field of the `Operation` proto.
	// The possible errors include:
	//
	//   - `INVALID_ARGUMENT`: One or more arguments are invalid.
	//   - `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//     action requested, such as a missing input or command or no worker being
	//     available. The client may be able to fix the errors and retry.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//     the action.
	//   - `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//     occupied (and the server does not support a queue), the action could not
	//     be started. The client should retry.
	//   - `INTERNAL`: An internal error occurred in the execution engine or the
	//     worker.
	//   - `DEADLINE_EXCEEDED`: The execution timed out.
	//   - `CANCELLED`: The operation was cancelled by the client. This status is
	//     only possible if the server implements the Operations API CancelOperation
	//     method, and it was called for the current execution.
	//
	// In the case of a missing input or command, the server SHOULD additionally
	// send a [PreconditionFailure][google.rpc.PreconditionFailure] error detail
	// where, for each requested blob not present in the CAS, there is a
	// `Violation` with a `type` of `MISSING` and a `subject` of
	// `"blobs/{digest_function/}{hash}/{size}"` indicating the digest of the
	// missing blob. The `subject` is formatted the same way as the
	// `resource_name` provided to
	// [ByteStream.Read][google.bytestream.ByteStream.Read], with the leading
	// instance name omitted. `digest_function` MUST thus be omitted if its value
	// is one of MD5, MURMUR3, SHA1, SHA256, SHA384, SHA512, or VSO.
	//
	// The server does not need to guarantee that a call to this method leads to
	// at most one execution of the action. The server MAY execute the action
	// multiple times, potentially in parallel. These redundant executions MAY
	// continue to run, even if the operation is completed.
	Execute(*ExecuteRequest, Execution_ExecuteServer) error
	// Wait for an execution operation to complete. When the client initially
	// makes the request, the server immediately responds with the current status
	// of the execution. The server will leave the request stream open until the
	// operation completes, and then respond with the completed operation. The
	// server MAY choose to stream additional updates as execution progresses,
	// such as to provide an update as to the state of the execution.
	//
	// In addition to the cases describe for Execute, the WaitExecution method
	// may fail as follows:
	//
	//   - `NOT_FOUND`: The operation no longer exists due to any of a transient
	//     condition, an unknown operation name, or if the server implements the
	//     Operations API DeleteOperation method and it was called for the current
	//     execution. The client should call `Execute` to retry.
	WaitExecution(*WaitExecutionRequest, Execution_WaitExecutionServer) error
}

// UnimplementedExecutionServer should be embedded to have forward compatible implementations.
type UnimplementedExecutionServer struct {
}

func (UnimplementedExecutionServer) Execute(*ExecuteRequest, Execution_ExecuteServer) error {
	return status.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (UnimplementedExecutionServer) WaitExecution(*WaitExecutionRequest, Execution_WaitExecutionServer) error {
	return status.Errorf(codes.Unimplemented, "method WaitExecution not implemented")
}

// UnsafeExecutionServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExecutionServer will
// result in compilation errors.
type UnsafeExecutionServer interface {
	mustEmbedUnimplementedExecutionServer()
}

func RegisterExecutionServer(s grpc.ServiceRegistrar, srv ExecutionServer) {
	s.RegisterService(&Execution_ServiceDesc, srv)
}

func _Execution_Execute_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ExecutionServer).Execute(m, &executionExecuteServer{stream})
}

type Execution_ExecuteServer interface {
	Send(*longrunningpb.Operation) error
	grpc.ServerStream
}

type executionExecuteServer struct {
	grpc.ServerStream
}

func (x *executionExecuteServer) Send(m *longrunningpb.Operation) error {
	return x.ServerStream.SendMsg(m)
}

func _Execution_WaitExecution_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WaitExecutionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ExecutionServer).WaitExecution(m, &executionWaitExecutionServer{stream})
}

type Execution_WaitExecutionServer interface {
	Send(*longrunningpb.Operation) error
	grpc.ServerStream
}

type executionWaitExecutionServer struct {
	grpc.ServerStream
}

func (x *executionWaitExecutionServer) Send(m *longrunningpb.Operation) error {
	return x.ServerStream.SendMsg(m)
}

// Execution_ServiceDesc is the grpc.ServiceDesc for Execution service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Execution_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.Execution",
	HandlerType: (*ExecutionServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Execute",
			Handler:       _Execution_Execute_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "WaitExecution",
			Handler:       _Execution_WaitExecution_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}

const (
	ActionCache_GetActionResult_FullMethodName    = "/build.bazel.remote.execution.v2.ActionCache/GetActionResult"
	ActionCache_UpdateActionResult_FullMethodName = "/build.bazel.remote.execution.v2.ActionCache/UpdateActionResult"
)

// ActionCacheClient is the client API for ActionCache service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ActionCacheClient interface {
	// Retrieve a cached execution result.
	//
	// Implementations SHOULD ensure that any blobs referenced from the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// are available at the time of returning the
	// [ActionResult][build.bazel.remote.execution.v2.ActionResult] and will be
	// for some period of time afterwards. The lifetimes of the referenced blobs SHOULD be increased
	// if necessary and applicable.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
	// Upload a new execution result.
	//
	// In order to allow the server to perform access control based on the type of
	// action, and to assist with client debugging, the client MUST first upload
	// the [Action][build.bazel.remote.execution.v2.Action] that produced the
	// result, along with its
	// [Command][build.bazel.remote.execution.v2.Command], into the
	// `ContentAddressableStorage`.
	//
	// Server implementations MAY modify the
	// `UpdateActionResultRequest.action_result` and return an equivalent value.
	//
	// Errors:
	//
	//   - `INVALID_ARGUMENT`: One or more arguments are invalid.
	//   - `FAILED_PRECONDITION`: One or more errors occurred in updating the
	//     action result, such as a missing command or action.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//     entry to the cache.
	UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
}

type actionCacheClient struct {
	cc grpc.ClientConnInterface
}

func NewActionCacheClient(cc grpc.ClientConnInterface) ActionCacheClient {
	return &actionCacheClient{cc}
}

func (c *actionCacheClient) GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := c.cc.Invoke(ctx, ActionCache_GetActionResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionCacheClient) UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := c.cc.Invoke(ctx, ActionCache_UpdateActionResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ActionCacheServer is the server API for ActionCache service.
// All implementations should embed UnimplementedActionCacheServer
// for forward compatibility
type ActionCacheServer interface {
	// Retrieve a cached execution result.
	//
	// Implementations SHOULD ensure that any blobs referenced from the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// are available at the time of returning the
	// [ActionResult][build.bazel.remote.execution.v2.ActionResult] and will be
	// for some period of time afterwards. The lifetimes of the referenced blobs SHOULD be increased
	// if necessary and applicable.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(context.Context, *GetActionResultRequest) (*ActionResult, error)
	// Upload a new execution result.
	//
	// In order to allow the server to perform access control based on the type of
	// action, and to assist with client debugging, the client MUST first upload
	// the [Action][build.bazel.remote.execution.v2.Action] that produced the
	// result, along with its
	// [Command][build.bazel.remote.execution.v2.Command], into the
	// `ContentAddressableStorage`.
	//
	// Server implementations MAY modify the
	// `UpdateActionResultRequest.action_result` and return an equivalent value.
	//
	// Errors:
	//
	//   - `INVALID_ARGUMENT`: One or more arguments are invalid.
	//   - `FAILED_PRECONDITION`: One or more errors occurred in updating the
	//     action result, such as a missing command or action.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//     entry to the cache.
	UpdateActionResult(context.Context, *UpdateActionResultRequest) (*ActionResult, error)
}

// UnimplementedActionCacheServer should be embedded to have forward compatible implementations.
type UnimplementedActionCacheServer struct {
}

func (UnimplementedActionCacheServer) GetActionResult(context.Context, *GetActionResultRequest) (*ActionResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActionResult not implemented")
}
func (UnimplementedActionCacheServer) UpdateActionResult(context.Context, *UpdateActionResultRequest) (*ActionResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateActionResult not implemented")
}

// UnsafeActionCacheServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ActionCacheServer will
// result in compilation errors.
type UnsafeActionCacheServer interface {
	mustEmbedUnimplementedActionCacheServer()
}

func RegisterActionCacheServer(s grpc.ServiceRegistrar, srv ActionCacheServer) {
	s.RegisterService(&ActionCache_ServiceDesc, srv)
}

func _ActionCache_GetActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).GetActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ActionCache_GetActionResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).GetActionResult(ctx, req.(*GetActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionCache_UpdateActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ActionCache_UpdateActionResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, req.(*UpdateActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ActionCache_ServiceDesc is the grpc.ServiceDesc for ActionCache service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ActionCache_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.ActionCache",
	HandlerType: (*ActionCacheServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetActionResult",
			Handler:    _ActionCache_GetActionResult_Handler,
		},
		{
			MethodName: "UpdateActionResult",
			Handler:    _ActionCache_UpdateActionResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}

const (
	ContentAddressableStorage_FindMissingBlobs_FullMethodName = "/build.bazel.remote.execution.v2.ContentAddressableStorage/FindMissingBlobs"
	ContentAddressableStorage_BatchUpdateBlobs_FullMethodName = "/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchUpdateBlobs"
	ContentAddressableStorage_BatchReadBlobs_FullMethodName   = "/build.bazel.remote.execution.v2.ContentAddressableStorage/BatchReadBlobs"
	ContentAddressableStorage_GetTree_FullMethodName          = "/build.bazel.remote.execution.v2.ContentAddressableStorage/GetTree"
)

// ContentAddressableStorageClient is the client API for ContentAddressableStorage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ContentAddressableStorageClient interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// Servers SHOULD increase the lifetimes of the referenced blobs if necessary and
	// applicable.
	//
	// There are no method-specific errors.
	FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be uploaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Write` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	//   - `INVALID_ARGUMENT`: The client attempted to upload more than the
	//     server supported limit.
	//
	// Individual requests may return the following errors, additionally:
	//
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The
	// [Digest][build.bazel.remote.execution.v2.Digest] does not match the
	// provided data.
	BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error)
	// Download many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be downloaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or downloaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Read` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	//   - `INVALID_ARGUMENT`: The client attempted to read more than the
	//     server supported limit.
	//
	// Every error on individual read will be returned in the corresponding digest
	// status.
	BatchReadBlobs(ctx context.Context, in *BatchReadBlobsRequest, opts ...grpc.CallOption) (*BatchReadBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][build.bazel.remote.execution.v2.Directory] stored in the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	//
	// The GetTreeRequest.page_token parameter can be used to skip ahead in
	// the stream (e.g. when retrying a partially completed and aborted request),
	// by setting it to a value taken from GetTreeResponse.next_page_token of the
	// last successfully processed GetTreeResponse).
	//
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (ContentAddressableStorage_GetTreeClient, error)
}

type contentAddressableStorageClient struct {
	cc grpc.ClientConnInterface
}

func NewContentAddressableStorageClient(cc grpc.ClientConnInterface) ContentAddressableStorageClient {
	return &contentAddressableStorageClient{cc}
}

func (c *contentAddressableStorageClient) FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error) {
	out := new(FindMissingBlobsResponse)
	err := c.cc.Invoke(ctx, ContentAddressableStorage_FindMissingBlobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error) {
	out := new(BatchUpdateBlobsResponse)
	err := c.cc.Invoke(ctx, ContentAddressableStorage_BatchUpdateBlobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) BatchReadBlobs(ctx context.Context, in *BatchReadBlobsRequest, opts ...grpc.CallOption) (*BatchReadBlobsResponse, error) {
	out := new(BatchReadBlobsResponse)
	err := c.cc.Invoke(ctx, ContentAddressableStorage_BatchReadBlobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (ContentAddressableStorage_GetTreeClient, error) {
	stream, err := c.cc.NewStream(ctx, &ContentAddressableStorage_ServiceDesc.Streams[0], ContentAddressableStorage_GetTree_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &contentAddressableStorageGetTreeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ContentAddressableStorage_GetTreeClient interface {
	Recv() (*GetTreeResponse, error)
	grpc.ClientStream
}

type contentAddressableStorageGetTreeClient struct {
	grpc.ClientStream
}

func (x *contentAddressableStorageGetTreeClient) Recv() (*GetTreeResponse, error) {
	m := new(GetTreeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ContentAddressableStorageServer is the server API for ContentAddressableStorage service.
// All implementations should embed UnimplementedContentAddressableStorageServer
// for forward compatibility
type ContentAddressableStorageServer interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// Servers SHOULD increase the lifetimes of the referenced blobs if necessary and
	// applicable.
	//
	// There are no method-specific errors.
	FindMissingBlobs(context.Context, *FindMissingBlobsRequest) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be uploaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Write` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	//   - `INVALID_ARGUMENT`: The client attempted to upload more than the
	//     server supported limit.
	//
	// Individual requests may return the following errors, additionally:
	//
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The
	// [Digest][build.bazel.remote.execution.v2.Digest] does not match the
	// provided data.
	BatchUpdateBlobs(context.Context, *BatchUpdateBlobsRequest) (*BatchUpdateBlobsResponse, error)
	// Download many blobs at once.
	//
	// The server may enforce a limit of the combined total size of blobs
	// to be downloaded using this API. This limit may be obtained using the
	// [Capabilities][build.bazel.remote.execution.v2.Capabilities] API.
	// Requests exceeding the limit should either be split into smaller
	// chunks or downloaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling a Bytestream `Read` request
	// on each individual blob, in parallel. The requests may succeed or fail
	// independently.
	//
	// Errors:
	//
	//   - `INVALID_ARGUMENT`: The client attempted to read more than the
	//     server supported limit.
	//
	// Every error on individual read will be returned in the corresponding digest
	// status.
	BatchReadBlobs(context.Context, *BatchReadBlobsRequest) (*BatchReadBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][build.bazel.remote.execution.v2.Directory] stored in the
	// [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	//
	// The GetTreeRequest.page_token parameter can be used to skip ahead in
	// the stream (e.g. when retrying a partially completed and aborted request),
	// by setting it to a value taken from GetTreeResponse.next_page_token of the
	// last successfully processed GetTreeResponse).
	//
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// Errors:
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(*GetTreeRequest, ContentAddressableStorage_GetTreeServer) error
}

// UnimplementedContentAddressableStorageServer should be embedded to have forward compatible implementations.
type UnimplementedContentAddressableStorageServer struct {
}

func (UnimplementedContentAddressableStorageServer) FindMissingBlobs(context.Context, *FindMissingBlobsRequest) (*FindMissingBlobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindMissingBlobs not implemented")
}
func (UnimplementedContentAddressableStorageServer) BatchUpdateBlobs(context.Context, *BatchUpdateBlobsRequest) (*BatchUpdateBlobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateBlobs not implemented")
}
func (UnimplementedContentAddressableStorageServer) BatchReadBlobs(context.Context, *BatchReadBlobsRequest) (*BatchReadBlobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchReadBlobs not implemented")
}
func (UnimplementedContentAddressableStorageServer) GetTree(*GetTreeRequest, ContentAddressableStorage_GetTreeServer) error {
	return status.Errorf(codes.Unimplemented, "method GetTree not implemented")
}

// UnsafeContentAddressableStorageServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ContentAddressableStorageServer will
// result in compilation errors.
type UnsafeContentAddressableStorageServer interface {
	mustEmbedUnimplementedContentAddressableStorageServer()
}

func RegisterContentAddressableStorageServer(s grpc.ServiceRegistrar, srv ContentAddressableStorageServer) {
	s.RegisterService(&ContentAddressableStorage_ServiceDesc, srv)
}

func _ContentAddressableStorage_FindMissingBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMissingBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContentAddressableStorage_FindMissingBlobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, req.(*FindMissingBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_BatchUpdateBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContentAddressableStorage_BatchUpdateBlobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, req.(*BatchUpdateBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_BatchReadBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchReadBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).BatchReadBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ContentAddressableStorage_BatchReadBlobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).BatchReadBlobs(ctx, req.(*BatchReadBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_GetTree_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTreeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ContentAddressableStorageServer).GetTree(m, &contentAddressableStorageGetTreeServer{stream})
}

type ContentAddressableStorage_GetTreeServer interface {
	Send(*GetTreeResponse) error
	grpc.ServerStream
}

type contentAddressableStorageGetTreeServer struct {
	grpc.ServerStream
}

func (x *contentAddressableStorageGetTreeServer) Send(m *GetTreeResponse) error {
	return x.ServerStream.SendMsg(m)
}

// ContentAddressableStorage_ServiceDesc is the grpc.ServiceDesc for ContentAddressableStorage service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ContentAddressableStorage_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.ContentAddressableStorage",
	HandlerType: (*ContentAddressableStorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindMissingBlobs",
			Handler:    _ContentAddressableStorage_FindMissingBlobs_Handler,
		},
		{
			MethodName: "BatchUpdateBlobs",
			Handler:    _ContentAddressableStorage_BatchUpdateBlobs_Handler,
		},
		{
			MethodName: "BatchReadBlobs",
			Handler:    _ContentAddressableStorage_BatchReadBlobs_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetTree",
			Handler:       _ContentAddressableStorage_GetTree_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}

const (
	Capabilities_GetCapabilities_FullMethodName = "/build.bazel.remote.execution.v2.Capabilities/GetCapabilities"
)

// CapabilitiesClient is the client API for Capabilities service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CapabilitiesClient interface {
	// GetCapabilities returns the server capabilities configuration of the
	// remote endpoint.
	// Only the capabilities of the services supported by the endpoint will
	// be returned:
	//   - Execution + CAS + Action Cache endpoints should return both
	//     CacheCapabilities and ExecutionCapabilities.
	//   - Execution only endpoints should return ExecutionCapabilities.
	//   - CAS + Action Cache only endpoints should return CacheCapabilities.
	//
	// There are no method-specific errors.
	GetCapabilities(ctx context.Context, in *GetCapabilitiesRequest, opts ...grpc.CallOption) (*ServerCapabilities, error)
}

type capabilitiesClient struct {
	cc grpc.ClientConnInterface
}

func NewCapabilitiesClient(cc grpc.ClientConnInterface) CapabilitiesClient {
	return &capabilitiesClient{cc}
}

func (c *capabilitiesClient) GetCapabilities(ctx context.Context, in *GetCapabilitiesRequest, opts ...grpc.CallOption) (*ServerCapabilities, error) {
	out := new(ServerCapabilities)
	err := c.cc.Invoke(ctx, Capabilities_GetCapabilities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CapabilitiesServer is the server API for Capabilities service.
// All implementations should embed UnimplementedCapabilitiesServer
// for forward compatibility
type CapabilitiesServer interface {
	// GetCapabilities returns the server capabilities configuration of the
	// remote endpoint.
	// Only the capabilities of the services supported by the endpoint will
	// be returned:
	//   - Execution + CAS + Action Cache endpoints should return both
	//     CacheCapabilities and ExecutionCapabilities.
	//   - Execution only endpoints should return ExecutionCapabilities.
	//   - CAS + Action Cache only endpoints should return CacheCapabilities.
	//
	// There are no method-specific errors.
	GetCapabilities(context.Context, *GetCapabilitiesRequest) (*ServerCapabilities, error)
}

// UnimplementedCapabilitiesServer should be embedded to have forward compatible implementations.
type UnimplementedCapabilitiesServer struct {
}

func (UnimplementedCapabilitiesServer) GetCapabilities(context.Context, *GetCapabilitiesRequest) (*ServerCapabilities, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCapabilities not implemented")
}

// UnsafeCapabilitiesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CapabilitiesServer will
// result in compilation errors.
type UnsafeCapabilitiesServer interface {
	mustEmbedUnimplementedCapabilitiesServer()
}

func RegisterCapabilitiesServer(s grpc.ServiceRegistrar, srv CapabilitiesServer) {
	s.RegisterService(&Capabilities_ServiceDesc, srv)
}

func _Capabilities_GetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CapabilitiesServer).GetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Capabilities_GetCapabilities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CapabilitiesServer).GetCapabilities(ctx, req.(*GetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Capabilities_ServiceDesc is the grpc.ServiceDesc for Capabilities service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Capabilities_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.execution.v2.Capabilities",
	HandlerType: (*CapabilitiesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCapabilities",
			Handler:    _Capabilities_GetCapabilities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "build/bazel/remote/execution/v2/remote_execution.proto",
}
