/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SphereGenerator;

public class Sphere
extends Shape3D {
    private static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_FACETS = 16;
    private SphereGenerator generator;
    private GeometryData data = new GeometryData();

    public Sphere() {
        this(1.0f, 16, null);
    }

    public Sphere(Appearance appearance) {
        this(1.0f, 16, appearance);
    }

    public Sphere(int n) {
        this(1.0f, n, null);
    }

    public Sphere(float f) {
        this(f, 16, null);
    }

    public Sphere(int n, Appearance appearance) {
        this(1.0f, n, appearance);
    }

    public Sphere(float f, Appearance appearance) {
        this(f, 16, appearance);
    }

    public Sphere(float f, int n, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new SphereGenerator(f, n);
        this.generator.generate(this.data);
        int n2 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n2, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setCapability(13);
        this.setAppearance(appearance);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setDimensions(float f) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setDimensions(f, true);
        this.generator.generate(this.data);
        int n = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setFacetCount(int n) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setFacetCount(n);
        this.generator.generate(this.data);
        int n2 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n2, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }
}

