/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ConstructDDFAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ConstructDDFAttributes::BinningScheme
//

static const char *BinningScheme_strings[] = {
"Uniform", "Unknown"};

std::string
ConstructDDFAttributes::BinningScheme_ToString(ConstructDDFAttributes::BinningScheme t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return BinningScheme_strings[index];
}

std::string
ConstructDDFAttributes::BinningScheme_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return BinningScheme_strings[index];
}

bool
ConstructDDFAttributes::BinningScheme_FromString(const std::string &s, ConstructDDFAttributes::BinningScheme &val)
{
    val = ConstructDDFAttributes::Uniform;
    for(int i = 0; i < 2; ++i)
    {
        if(s == BinningScheme_strings[i])
        {
            val = (BinningScheme)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for ConstructDDFAttributes::StatisticalOperator
//

static const char *StatisticalOperator_strings[] = {
"Average", "Minimum", "Maximum", 
"StandardDeviation", "Variance", "Percentile", 
"Median", "InterquartileRange", "Sum", 
"Count"};

std::string
ConstructDDFAttributes::StatisticalOperator_ToString(ConstructDDFAttributes::StatisticalOperator t)
{
    int index = int(t);
    if(index < 0 || index >= 10) index = 0;
    return StatisticalOperator_strings[index];
}

std::string
ConstructDDFAttributes::StatisticalOperator_ToString(int t)
{
    int index = (t < 0 || t >= 10) ? 0 : t;
    return StatisticalOperator_strings[index];
}

bool
ConstructDDFAttributes::StatisticalOperator_FromString(const std::string &s, ConstructDDFAttributes::StatisticalOperator &val)
{
    val = ConstructDDFAttributes::Average;
    for(int i = 0; i < 10; ++i)
    {
        if(s == StatisticalOperator_strings[i])
        {
            val = (StatisticalOperator)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *ConstructDDFAttributes::TypeMapFormatString = "ss*d*siddii*biii";

// ****************************************************************************
// Method: ConstructDDFAttributes::ConstructDDFAttributes
//
// Purpose: 
//   Constructor for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConstructDDFAttributes::ConstructDDFAttributes() : 
    AttributeSubject(ConstructDDFAttributes::TypeMapFormatString)
{
    statisticalOperator = Average;
    percentile = 90;
    undefinedValue = 0;
    binningScheme = Uniform;
    overTime = false;
    timeStart = 0;
    timeEnd = 1;
    timeStride = 1;
}

// ****************************************************************************
// Method: ConstructDDFAttributes::ConstructDDFAttributes
//
// Purpose: 
//   Copy constructor for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConstructDDFAttributes::ConstructDDFAttributes(const ConstructDDFAttributes &obj) : 
    AttributeSubject(ConstructDDFAttributes::TypeMapFormatString)
{
    ddfName = obj.ddfName;
    varnames = obj.varnames;
    ranges = obj.ranges;
    codomainName = obj.codomainName;
    statisticalOperator = obj.statisticalOperator;
    percentile = obj.percentile;
    undefinedValue = obj.undefinedValue;
    binningScheme = obj.binningScheme;
    numSamples = obj.numSamples;
    overTime = obj.overTime;
    timeStart = obj.timeStart;
    timeEnd = obj.timeEnd;
    timeStride = obj.timeStride;

    SelectAll();
}

// ****************************************************************************
// Method: ConstructDDFAttributes::~ConstructDDFAttributes
//
// Purpose: 
//   Destructor for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConstructDDFAttributes::~ConstructDDFAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ConstructDDFAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ConstructDDFAttributes& 
ConstructDDFAttributes::operator = (const ConstructDDFAttributes &obj)
{
    if (this == &obj) return *this;
    ddfName = obj.ddfName;
    varnames = obj.varnames;
    ranges = obj.ranges;
    codomainName = obj.codomainName;
    statisticalOperator = obj.statisticalOperator;
    percentile = obj.percentile;
    undefinedValue = obj.undefinedValue;
    binningScheme = obj.binningScheme;
    numSamples = obj.numSamples;
    overTime = obj.overTime;
    timeStart = obj.timeStart;
    timeEnd = obj.timeEnd;
    timeStride = obj.timeStride;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ConstructDDFAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConstructDDFAttributes::operator == (const ConstructDDFAttributes &obj) const
{
    // Create the return value
    return ((ddfName == obj.ddfName) &&
            (varnames == obj.varnames) &&
            (ranges == obj.ranges) &&
            (codomainName == obj.codomainName) &&
            (statisticalOperator == obj.statisticalOperator) &&
            (percentile == obj.percentile) &&
            (undefinedValue == obj.undefinedValue) &&
            (binningScheme == obj.binningScheme) &&
            (numSamples == obj.numSamples) &&
            (overTime == obj.overTime) &&
            (timeStart == obj.timeStart) &&
            (timeEnd == obj.timeEnd) &&
            (timeStride == obj.timeStride));
}

// ****************************************************************************
// Method: ConstructDDFAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConstructDDFAttributes::operator != (const ConstructDDFAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ConstructDDFAttributes::TypeName
//
// Purpose: 
//   Type name method for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ConstructDDFAttributes::TypeName() const
{
    return "ConstructDDFAttributes";
}

// ****************************************************************************
// Method: ConstructDDFAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConstructDDFAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ConstructDDFAttributes *tmp = (const ConstructDDFAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ConstructDDFAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ConstructDDFAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ConstructDDFAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ConstructDDFAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ConstructDDFAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ConstructDDFAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ConstructDDFAttributes(*this);
    else
        retval = new ConstructDDFAttributes;

    return retval;
}

// ****************************************************************************
// Method: ConstructDDFAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ConstructDDFAttributes::SelectAll()
{
    Select(ID_ddfName,             (void *)&ddfName);
    Select(ID_varnames,            (void *)&varnames);
    Select(ID_ranges,              (void *)&ranges);
    Select(ID_codomainName,        (void *)&codomainName);
    Select(ID_statisticalOperator, (void *)&statisticalOperator);
    Select(ID_percentile,          (void *)&percentile);
    Select(ID_undefinedValue,      (void *)&undefinedValue);
    Select(ID_binningScheme,       (void *)&binningScheme);
    Select(ID_numSamples,          (void *)&numSamples);
    Select(ID_overTime,            (void *)&overTime);
    Select(ID_timeStart,           (void *)&timeStart);
    Select(ID_timeEnd,             (void *)&timeEnd);
    Select(ID_timeStride,          (void *)&timeStride);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ConstructDDFAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConstructDDFAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ConstructDDFAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ConstructDDFAttributes.
    DataNode *node = new DataNode("ConstructDDFAttributes");

    if(completeSave || !FieldsEqual(ID_ddfName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ddfName", ddfName));
    }

    if(completeSave || !FieldsEqual(ID_varnames, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("varnames", varnames));
    }

    if(completeSave || !FieldsEqual(ID_ranges, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ranges", ranges));
    }

    if(completeSave || !FieldsEqual(ID_codomainName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("codomainName", codomainName));
    }

    if(completeSave || !FieldsEqual(ID_statisticalOperator, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("statisticalOperator", StatisticalOperator_ToString(statisticalOperator)));
    }

    if(completeSave || !FieldsEqual(ID_percentile, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("percentile", percentile));
    }

    if(completeSave || !FieldsEqual(ID_undefinedValue, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("undefinedValue", undefinedValue));
    }

    if(completeSave || !FieldsEqual(ID_binningScheme, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("binningScheme", BinningScheme_ToString(binningScheme)));
    }

    if(completeSave || !FieldsEqual(ID_numSamples, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numSamples", numSamples));
    }

    if(completeSave || !FieldsEqual(ID_overTime, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("overTime", overTime));
    }

    if(completeSave || !FieldsEqual(ID_timeStart, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeStart", timeStart));
    }

    if(completeSave || !FieldsEqual(ID_timeEnd, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeEnd", timeEnd));
    }

    if(completeSave || !FieldsEqual(ID_timeStride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeStride", timeStride));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ConstructDDFAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ConstructDDFAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ConstructDDFAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("ddfName")) != 0)
        SetDdfName(node->AsString());
    if((node = searchNode->GetNode("varnames")) != 0)
        SetVarnames(node->AsStringVector());
    if((node = searchNode->GetNode("ranges")) != 0)
        SetRanges(node->AsDoubleVector());
    if((node = searchNode->GetNode("codomainName")) != 0)
        SetCodomainName(node->AsString());
    if((node = searchNode->GetNode("statisticalOperator")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 10)
                SetStatisticalOperator(StatisticalOperator(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            StatisticalOperator value;
            if(StatisticalOperator_FromString(node->AsString(), value))
                SetStatisticalOperator(value);
        }
    }
    if((node = searchNode->GetNode("percentile")) != 0)
        SetPercentile(node->AsDouble());
    if((node = searchNode->GetNode("undefinedValue")) != 0)
        SetUndefinedValue(node->AsDouble());
    if((node = searchNode->GetNode("binningScheme")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetBinningScheme(BinningScheme(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            BinningScheme value;
            if(BinningScheme_FromString(node->AsString(), value))
                SetBinningScheme(value);
        }
    }
    if((node = searchNode->GetNode("numSamples")) != 0)
        SetNumSamples(node->AsIntVector());
    if((node = searchNode->GetNode("overTime")) != 0)
        SetOverTime(node->AsBool());
    if((node = searchNode->GetNode("timeStart")) != 0)
        SetTimeStart(node->AsInt());
    if((node = searchNode->GetNode("timeEnd")) != 0)
        SetTimeEnd(node->AsInt());
    if((node = searchNode->GetNode("timeStride")) != 0)
        SetTimeStride(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ConstructDDFAttributes::SetDdfName(const std::string &ddfName_)
{
    ddfName = ddfName_;
    Select(ID_ddfName, (void *)&ddfName);
}

void
ConstructDDFAttributes::SetVarnames(const stringVector &varnames_)
{
    varnames = varnames_;
    Select(ID_varnames, (void *)&varnames);
}

void
ConstructDDFAttributes::SetRanges(const doubleVector &ranges_)
{
    ranges = ranges_;
    Select(ID_ranges, (void *)&ranges);
}

void
ConstructDDFAttributes::SetCodomainName(const std::string &codomainName_)
{
    codomainName = codomainName_;
    Select(ID_codomainName, (void *)&codomainName);
}

void
ConstructDDFAttributes::SetStatisticalOperator(ConstructDDFAttributes::StatisticalOperator statisticalOperator_)
{
    statisticalOperator = statisticalOperator_;
    Select(ID_statisticalOperator, (void *)&statisticalOperator);
}

void
ConstructDDFAttributes::SetPercentile(double percentile_)
{
    percentile = percentile_;
    Select(ID_percentile, (void *)&percentile);
}

void
ConstructDDFAttributes::SetUndefinedValue(double undefinedValue_)
{
    undefinedValue = undefinedValue_;
    Select(ID_undefinedValue, (void *)&undefinedValue);
}

void
ConstructDDFAttributes::SetBinningScheme(ConstructDDFAttributes::BinningScheme binningScheme_)
{
    binningScheme = binningScheme_;
    Select(ID_binningScheme, (void *)&binningScheme);
}

void
ConstructDDFAttributes::SetNumSamples(const intVector &numSamples_)
{
    numSamples = numSamples_;
    Select(ID_numSamples, (void *)&numSamples);
}

void
ConstructDDFAttributes::SetOverTime(bool overTime_)
{
    overTime = overTime_;
    Select(ID_overTime, (void *)&overTime);
}

void
ConstructDDFAttributes::SetTimeStart(int timeStart_)
{
    timeStart = timeStart_;
    Select(ID_timeStart, (void *)&timeStart);
}

void
ConstructDDFAttributes::SetTimeEnd(int timeEnd_)
{
    timeEnd = timeEnd_;
    Select(ID_timeEnd, (void *)&timeEnd);
}

void
ConstructDDFAttributes::SetTimeStride(int timeStride_)
{
    timeStride = timeStride_;
    Select(ID_timeStride, (void *)&timeStride);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
ConstructDDFAttributes::GetDdfName() const
{
    return ddfName;
}

std::string &
ConstructDDFAttributes::GetDdfName()
{
    return ddfName;
}

const stringVector &
ConstructDDFAttributes::GetVarnames() const
{
    return varnames;
}

stringVector &
ConstructDDFAttributes::GetVarnames()
{
    return varnames;
}

const doubleVector &
ConstructDDFAttributes::GetRanges() const
{
    return ranges;
}

doubleVector &
ConstructDDFAttributes::GetRanges()
{
    return ranges;
}

const std::string &
ConstructDDFAttributes::GetCodomainName() const
{
    return codomainName;
}

std::string &
ConstructDDFAttributes::GetCodomainName()
{
    return codomainName;
}

ConstructDDFAttributes::StatisticalOperator
ConstructDDFAttributes::GetStatisticalOperator() const
{
    return StatisticalOperator(statisticalOperator);
}

double
ConstructDDFAttributes::GetPercentile() const
{
    return percentile;
}

double
ConstructDDFAttributes::GetUndefinedValue() const
{
    return undefinedValue;
}

ConstructDDFAttributes::BinningScheme
ConstructDDFAttributes::GetBinningScheme() const
{
    return BinningScheme(binningScheme);
}

const intVector &
ConstructDDFAttributes::GetNumSamples() const
{
    return numSamples;
}

intVector &
ConstructDDFAttributes::GetNumSamples()
{
    return numSamples;
}

bool
ConstructDDFAttributes::GetOverTime() const
{
    return overTime;
}

int
ConstructDDFAttributes::GetTimeStart() const
{
    return timeStart;
}

int
ConstructDDFAttributes::GetTimeEnd() const
{
    return timeEnd;
}

int
ConstructDDFAttributes::GetTimeStride() const
{
    return timeStride;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ConstructDDFAttributes::SelectDdfName()
{
    Select(ID_ddfName, (void *)&ddfName);
}

void
ConstructDDFAttributes::SelectVarnames()
{
    Select(ID_varnames, (void *)&varnames);
}

void
ConstructDDFAttributes::SelectRanges()
{
    Select(ID_ranges, (void *)&ranges);
}

void
ConstructDDFAttributes::SelectCodomainName()
{
    Select(ID_codomainName, (void *)&codomainName);
}

void
ConstructDDFAttributes::SelectNumSamples()
{
    Select(ID_numSamples, (void *)&numSamples);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ConstructDDFAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ConstructDDFAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_ddfName:             return "ddfName";
    case ID_varnames:            return "varnames";
    case ID_ranges:              return "ranges";
    case ID_codomainName:        return "codomainName";
    case ID_statisticalOperator: return "statisticalOperator";
    case ID_percentile:          return "percentile";
    case ID_undefinedValue:      return "undefinedValue";
    case ID_binningScheme:       return "binningScheme";
    case ID_numSamples:          return "numSamples";
    case ID_overTime:            return "overTime";
    case ID_timeStart:           return "timeStart";
    case ID_timeEnd:             return "timeEnd";
    case ID_timeStride:          return "timeStride";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ConstructDDFAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ConstructDDFAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_ddfName:             return FieldType_string;
    case ID_varnames:            return FieldType_stringVector;
    case ID_ranges:              return FieldType_doubleVector;
    case ID_codomainName:        return FieldType_string;
    case ID_statisticalOperator: return FieldType_enum;
    case ID_percentile:          return FieldType_double;
    case ID_undefinedValue:      return FieldType_double;
    case ID_binningScheme:       return FieldType_enum;
    case ID_numSamples:          return FieldType_intVector;
    case ID_overTime:            return FieldType_bool;
    case ID_timeStart:           return FieldType_int;
    case ID_timeEnd:             return FieldType_int;
    case ID_timeStride:          return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ConstructDDFAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ConstructDDFAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_ddfName:             return "string";
    case ID_varnames:            return "stringVector";
    case ID_ranges:              return "doubleVector";
    case ID_codomainName:        return "string";
    case ID_statisticalOperator: return "enum";
    case ID_percentile:          return "double";
    case ID_undefinedValue:      return "double";
    case ID_binningScheme:       return "enum";
    case ID_numSamples:          return "intVector";
    case ID_overTime:            return "bool";
    case ID_timeStart:           return "int";
    case ID_timeEnd:             return "int";
    case ID_timeStride:          return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ConstructDDFAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ConstructDDFAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ConstructDDFAttributes &obj = *((const ConstructDDFAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_ddfName:
        {  // new scope
        retval = (ddfName == obj.ddfName);
        }
        break;
    case ID_varnames:
        {  // new scope
        retval = (varnames == obj.varnames);
        }
        break;
    case ID_ranges:
        {  // new scope
        retval = (ranges == obj.ranges);
        }
        break;
    case ID_codomainName:
        {  // new scope
        retval = (codomainName == obj.codomainName);
        }
        break;
    case ID_statisticalOperator:
        {  // new scope
        retval = (statisticalOperator == obj.statisticalOperator);
        }
        break;
    case ID_percentile:
        {  // new scope
        retval = (percentile == obj.percentile);
        }
        break;
    case ID_undefinedValue:
        {  // new scope
        retval = (undefinedValue == obj.undefinedValue);
        }
        break;
    case ID_binningScheme:
        {  // new scope
        retval = (binningScheme == obj.binningScheme);
        }
        break;
    case ID_numSamples:
        {  // new scope
        retval = (numSamples == obj.numSamples);
        }
        break;
    case ID_overTime:
        {  // new scope
        retval = (overTime == obj.overTime);
        }
        break;
    case ID_timeStart:
        {  // new scope
        retval = (timeStart == obj.timeStart);
        }
        break;
    case ID_timeEnd:
        {  // new scope
        retval = (timeEnd == obj.timeEnd);
        }
        break;
    case ID_timeStride:
        {  // new scope
        retval = (timeStride == obj.timeStride);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

