#  Union Station - https://www.unionstationapp.com/
#  Copyright (c) 2010-2015 Phusion Holding B.V.
#
#  "Union Station" and "Passenger" are trademarks of Phusion Holding B.V.
#
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in
#  all copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
#  THE SOFTWARE.


module UnionStationHooks
  # Provides methods for `union_station_*` gems to log internal warnings and
  # debugging messages. This module is *not* to be used by application
  # developers for the purpose of logging information to Union Station.
  #
  # @private
  module Log
    @@debugging = false
    @@warn_callback = nil
    @@debug_callback = nil

    def self.debugging=(value)
      @@debugging = value
    end

    def self.warn(message)
      if @@warn_callback
        @@warn_callback.call(message)
      else
        STDERR.puts("[UnionStationHooks] #{message}")
      end
    end

    def self.debug(message)
      if @@debugging
        if @@debug_callback
          @@debug_callback.call(message)
        else
          STDERR.puts("[UnionStationHooks] #{message}")
        end
      end
    end

    def self.warn_callback=(cb)
      @@warn_callback = cb
    end

    def self.debug_callback=(cb)
      @@debug_callback = cb
    end
  end
end
