<?php


namespace Fig\Link\Tests;

use Fig\Link\GenericLinkProvider;
use Fig\Link\Link;
use PHPUnit\Framework\TestCase;

class GenericLinkProviderTest extends TestCase
{

    public function test_can_add_links_by_method(): void
    {
        $link = (new Link())
            ->withHref('http://www.google.com')
            ->withRel('next')
            ->withAttribute('me', 'you')
        ;

        $provider = (new GenericLinkProvider())
            ->withLink($link);

        $this->assertContains($link, $provider->getLinks());
    }


    public function test_can_add_links_by_constructor(): void
    {
        $link = (new Link())
            ->withHref('http://www.google.com')
            ->withRel('next')
            ->withAttribute('me', 'you')
        ;

        $provider = (new GenericLinkProvider())
            ->withLink($link);

        $this->assertContains($link, $provider->getLinks());
    }

    public function test_can_get_links_by_rel(): void
    {
        $link1 = (new Link())
            ->withHref('http://www.google.com')
            ->withRel('next')
            ->withAttribute('me', 'you')
        ;
        $link2 = (new Link())
            ->withHref('http://www.php-fig.org/')
            ->withRel('home')
            ->withAttribute('me', 'you')
        ;

        $provider = (new GenericLinkProvider())
            ->withLink($link1)
            ->withLink($link2);

        $links = $provider->getLinksByRel('home');
        $this->assertContains($link2, $links);
        $this->assertFalse(in_array($link1, $links));
    }

    public function test_can_remove_links(): void
    {
        $link = (new Link())
            ->withHref('http://www.google.com')
            ->withRel('next')
            ->withAttribute('me', 'you')
        ;

        $provider = (new GenericLinkProvider())
            ->withLink($link)
            ->withoutLink($link);

        $this->assertFalse(in_array($link, $provider->getLinks()));
    }
}
