/*
 * Copyright 2014  Martin Klapetek <mklapetek@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "timezonesi18n.h"

#include <KLocalizedString>

TimezonesI18n::TimezonesI18n(QObject *parent)
    : QObject(parent),
      m_isInitialized(false)
{

}

QString TimezonesI18n::i18nCity(const QString &city)
{
    if (!m_isInitialized) {
        init();
    }
    return m_i18nCities.value(city);
}

QString TimezonesI18n::i18nContinents(const QString &continent)
{
    if (!m_isInitialized) {
        init();
    }
    return m_i18nContinents.value(continent);
}

QString TimezonesI18n::i18nCountry(QLocale::Country country)
{
    if (!m_isInitialized) {
        init();
    }
    return m_i18nCountries.value(country);
}

void TimezonesI18n::init()
{
    m_i18nCities = QHash<QString, QString>({
        {QStringLiteral("Abidjan"), i18nc("This is a city associated with particular time zone", "Abidjan")},
        {QStringLiteral("Accra"), i18nc("This is a city associated with particular time zone", "Accra")},
        {QStringLiteral("Adak"), i18nc("This is a city associated with particular time zone", "Adak")},
        {QStringLiteral("Addis_Ababa"), i18nc("This is a city associated with particular time zone", "Addis Ababa")},
        {QStringLiteral("Adelaide"), i18nc("This is a city associated with particular time zone", "Adelaide")},
        {QStringLiteral("Aden"), i18nc("This is a city associated with particular time zone", "Aden")},
        {QStringLiteral("Algiers"), i18nc("This is a city associated with particular time zone", "Algiers")},
        {QStringLiteral("Almaty"), i18nc("This is a city associated with particular time zone", "Almaty")},
        {QStringLiteral("Amman"), i18nc("This is a city associated with particular time zone", "Amman")},
        {QStringLiteral("Amsterdam"), i18nc("This is a city associated with particular time zone", "Amsterdam")},
        {QStringLiteral("Anadyr"), i18nc("This is a city associated with particular time zone", "Anadyr")},
        {QStringLiteral("Anchorage"), i18nc("This is a city associated with particular time zone", "Anchorage")},
        {QStringLiteral("Andorra"), i18nc("This is a city associated with particular time zone", "Andorra")},
        {QStringLiteral("Anguilla"), i18nc("This is a city associated with particular time zone", "Anguilla")},
        {QStringLiteral("Antananarivo"), i18nc("This is a city associated with particular time zone", "Antananarivo")},
        {QStringLiteral("Antigua"), i18nc("This is a city associated with particular time zone", "Antigua")},
        {QStringLiteral("Apia"), i18nc("This is a city associated with particular time zone", "Apia")},
        {QStringLiteral("Aqtau"), i18nc("This is a city associated with particular time zone", "Aqtau")},
        {QStringLiteral("Aqtobe"), i18nc("This is a city associated with particular time zone", "Aqtobe")},
        {QStringLiteral("Araguaina"), i18nc("This is a city associated with particular time zone", "Araguaina")},
        {QStringLiteral("Aruba"), i18nc("This is a city associated with particular time zone", "Aruba")},
        {QStringLiteral("Ashgabat"), i18nc("This is a city associated with particular time zone", "Ashgabat")},
        {QStringLiteral("Asmara"), i18nc("This is a city associated with particular time zone", "Asmara")},
        {QStringLiteral("Asuncion"), i18nc("This is a city associated with particular time zone", "Asuncion")},
        {QStringLiteral("Athens"), i18nc("This is a city associated with particular time zone", "Athens")},
        {QStringLiteral("Atikokan"), i18nc("This is a city associated with particular time zone", "Atikokan")},
        {QStringLiteral("Auckland"), i18nc("This is a city associated with particular time zone", "Auckland")},
        {QStringLiteral("Azores"), i18nc("This is a city associated with particular time zone", "Azores")},
        {QStringLiteral("Baghdad"), i18nc("This is a city associated with particular time zone", "Baghdad")},
        {QStringLiteral("Bahia_Banderas"), i18nc("This is a city associated with particular time zone", "Bahia Banderas")},
        {QStringLiteral("Bahia"), i18nc("This is a city associated with particular time zone", "Bahia")},
        {QStringLiteral("Bahrain"), i18nc("This is a city associated with particular time zone", "Bahrain")},
        {QStringLiteral("Baku"), i18nc("This is a city associated with particular time zone", "Baku")},
        {QStringLiteral("Bamako"), i18nc("This is a city associated with particular time zone", "Bamako")},
        {QStringLiteral("Bangkok"), i18nc("This is a city associated with particular time zone", "Bangkok")},
        {QStringLiteral("Bangui"), i18nc("This is a city associated with particular time zone", "Bangui")},
        {QStringLiteral("Banjul"), i18nc("This is a city associated with particular time zone", "Banjul")},
        {QStringLiteral("Barbados"), i18nc("This is a city associated with particular time zone", "Barbados")},
        {QStringLiteral("Beirut"), i18nc("This is a city associated with particular time zone", "Beirut")},
        {QStringLiteral("Belem"), i18nc("This is a city associated with particular time zone", "Belem")},
        {QStringLiteral("Belgrade"), i18nc("This is a city associated with particular time zone", "Belgrade")},
        {QStringLiteral("Belize"), i18nc("This is a city associated with particular time zone", "Belize")},
        {QStringLiteral("Berlin"), i18nc("This is a city associated with particular time zone", "Berlin")},
        {QStringLiteral("Bermuda"), i18nc("This is a city associated with particular time zone", "Bermuda")},
        {QStringLiteral("Beulah"), i18nc("This is a city associated with particular time zone", "Beulah")},
        {QStringLiteral("Bishkek"), i18nc("This is a city associated with particular time zone", "Bishkek")},
        {QStringLiteral("Bissau"), i18nc("This is a city associated with particular time zone", "Bissau")},
        {QStringLiteral("Blanc-Sablon"), i18nc("This is a city associated with particular time zone", "Blanc-Sablon")},
        {QStringLiteral("Blantyre"), i18nc("This is a city associated with particular time zone", "Blantyre")},
        {QStringLiteral("Boa_Vista"), i18nc("This is a city associated with particular time zone", "Boa Vista")},
        {QStringLiteral("Bogota"), i18nc("This is a city associated with particular time zone", "Bogota")},
        {QStringLiteral("Boise"), i18nc("This is a city associated with particular time zone", "Boise")},
        {QStringLiteral("Bratislava"), i18nc("This is a city associated with particular time zone", "Bratislava")},
        {QStringLiteral("Brazzaville"), i18nc("This is a city associated with particular time zone", "Brazzaville")},
        {QStringLiteral("Brisbane"), i18nc("This is a city associated with particular time zone", "Brisbane")},
        {QStringLiteral("Broken_Hill"), i18nc("This is a city associated with particular time zone", "Broken Hill")},
        {QStringLiteral("Brunei"), i18nc("This is a city associated with particular time zone", "Brunei")},
        {QStringLiteral("Brussels"), i18nc("This is a city associated with particular time zone", "Brussels")},
        {QStringLiteral("Bucharest"), i18nc("This is a city associated with particular time zone", "Bucharest")},
        {QStringLiteral("Budapest"), i18nc("This is a city associated with particular time zone", "Budapest")},
        {QStringLiteral("Buenos_Aires"), i18nc("This is a city associated with particular time zone", "Buenos Aires")},
        {QStringLiteral("Bujumbura"), i18nc("This is a city associated with particular time zone", "Bujumbura")},
        {QStringLiteral("Busingen"), i18nc("This is a city associated with particular time zone", "Busingen")},
        {QStringLiteral("Cairo"), i18nc("This is a city associated with particular time zone", "Cairo")},
        {QStringLiteral("Cambridge_Bay"), i18nc("This is a city associated with particular time zone", "Cambridge Bay")},
        {QStringLiteral("Campo_Grande"), i18nc("This is a city associated with particular time zone", "Campo Grande")},
        {QStringLiteral("Canary"), i18nc("This is a city associated with particular time zone", "Canary")},
        {QStringLiteral("Cancun"), i18nc("This is a city associated with particular time zone", "Cancun")},
        {QStringLiteral("Cape_Verde"), i18nc("This is a city associated with particular time zone", "Cape Verde")},
        {QStringLiteral("Caracas"), i18nc("This is a city associated with particular time zone", "Caracas")},
        {QStringLiteral("Casablanca"), i18nc("This is a city associated with particular time zone", "Casablanca")},
        {QStringLiteral("Casey"), i18nc("This is a city associated with particular time zone", "Casey")},
        {QStringLiteral("Catamarca"), i18nc("This is a city associated with particular time zone", "Catamarca")},
        {QStringLiteral("Cayenne"), i18nc("This is a city associated with particular time zone", "Cayenne")},
        {QStringLiteral("Cayman"), i18nc("This is a city associated with particular time zone", "Cayman")},
        {QStringLiteral("Center"), i18nc("This is a city associated with particular time zone", "Center")},
        {QStringLiteral("Ceuta"), i18nc("This is a city associated with particular time zone", "Ceuta")},
        {QStringLiteral("Chagos"), i18nc("This is a city associated with particular time zone", "Chagos")},
        {QStringLiteral("Chatham"), i18nc("This is a city associated with particular time zone", "Chatham")},
        {QStringLiteral("Chicago"), i18nc("This is a city associated with particular time zone", "Chicago")},
        {QStringLiteral("Chihuahua"), i18nc("This is a city associated with particular time zone", "Chihuahua")},
        {QStringLiteral("Chisinau"), i18nc("This is a city associated with particular time zone", "Chisinau")},
        {QStringLiteral("Choibalsan"), i18nc("This is a city associated with particular time zone", "Choibalsan")},
        {QStringLiteral("Chongqing"), i18nc("This is a city associated with particular time zone", "Chongqing")},
        {QStringLiteral("Christmas"), i18nc("This is a city associated with particular time zone", "Christmas")},
        {QStringLiteral("Chuuk"), i18nc("This is a city associated with particular time zone", "Chuuk")},
        {QStringLiteral("Cocos"), i18nc("This is a city associated with particular time zone", "Cocos")},
        {QStringLiteral("Colombo"), i18nc("This is a city associated with particular time zone", "Colombo")},
        {QStringLiteral("Comoro"), i18nc("This is a city associated with particular time zone", "Comoro")},
        {QStringLiteral("Conakry"), i18nc("This is a city associated with particular time zone", "Conakry")},
        {QStringLiteral("Copenhagen"), i18nc("This is a city associated with particular time zone", "Copenhagen")},
        {QStringLiteral("Cordoba"), i18nc("This is a city associated with particular time zone", "Cordoba")},
        {QStringLiteral("Costa_Rica"), i18nc("This is a city associated with particular time zone", "Costa Rica")},
        {QStringLiteral("Creston"), i18nc("This is a city associated with particular time zone", "Creston")},
        {QStringLiteral("Cuiaba"), i18nc("This is a city associated with particular time zone", "Cuiaba")},
        {QStringLiteral("Curacao"), i18nc("This is a city associated with particular time zone", "Curacao")},
        {QStringLiteral("Currie"), i18nc("This is a city associated with particular time zone", "Currie")},
        {QStringLiteral("Dakar"), i18nc("This is a city associated with particular time zone", "Dakar")},
        {QStringLiteral("Damascus"), i18nc("This is a city associated with particular time zone", "Damascus")},
        {QStringLiteral("Danmarkshavn"), i18nc("This is a city associated with particular time zone", "Danmarkshavn")},
        {QStringLiteral("Dar_es_Salaam"), i18nc("This is a city associated with particular time zone", "Dar es Salaam")},
        {QStringLiteral("Darwin"), i18nc("This is a city associated with particular time zone", "Darwin")},
        {QStringLiteral("Davis"), i18nc("This is a city associated with particular time zone", "Davis")},
        {QStringLiteral("Dawson_Creek"), i18nc("This is a city associated with particular time zone", "Dawson Creek")},
        {QStringLiteral("Dawson"), i18nc("This is a city associated with particular time zone", "Dawson")},
        {QStringLiteral("Denver"), i18nc("This is a city associated with particular time zone", "Denver")},
        {QStringLiteral("Detroit"), i18nc("This is a city associated with particular time zone", "Detroit")},
        {QStringLiteral("Dhaka"), i18nc("This is a city associated with particular time zone", "Dhaka")},
        {QStringLiteral("Dili"), i18nc("This is a city associated with particular time zone", "Dili")},
        {QStringLiteral("Djibouti"), i18nc("This is a city associated with particular time zone", "Djibouti")},
        {QStringLiteral("Dominica"), i18nc("This is a city associated with particular time zone", "Dominica")},
        {QStringLiteral("Douala"), i18nc("This is a city associated with particular time zone", "Douala")},
        {QStringLiteral("Dubai"), i18nc("This is a city associated with particular time zone", "Dubai")},
        {QStringLiteral("Dublin"), i18nc("This is a city associated with particular time zone", "Dublin")},
        {QStringLiteral("DumontDUrville"), i18nc("This is a city associated with particular time zone", "Dumont d’Urville")},
        {QStringLiteral("Dushanbe"), i18nc("This is a city associated with particular time zone", "Dushanbe")},
        {QStringLiteral("Easter"), i18nc("This is a city associated with particular time zone", "Easter")},
        {QStringLiteral("Edmonton"), i18nc("This is a city associated with particular time zone", "Edmonton")},
        {QStringLiteral("Efate"), i18nc("This is a city associated with particular time zone", "Efate")},
        {QStringLiteral("Eirunepe"), i18nc("This is a city associated with particular time zone", "Eirunepe")},
        {QStringLiteral("El_Aaiun"), i18nc("This is a city associated with particular time zone", "El Aaiun")},
        {QStringLiteral("El_Salvador"), i18nc("This is a city associated with particular time zone", "El Salvador")},
        {QStringLiteral("Enderbury"), i18nc("This is a city associated with particular time zone", "Enderbury")},
        {QStringLiteral("Eucla"), i18nc("This is a city associated with particular time zone", "Eucla")},
        {QStringLiteral("Fakaofo"), i18nc("This is a city associated with particular time zone", "Fakaofo")},
        {QStringLiteral("Faroe"), i18nc("This is a city associated with particular time zone", "Faroe")},
        {QStringLiteral("Fiji"), i18nc("This is a city associated with particular time zone", "Fiji")},
        {QStringLiteral("Fortaleza"), i18nc("This is a city associated with particular time zone", "Fortaleza")},
        {QStringLiteral("Freetown"), i18nc("This is a city associated with particular time zone", "Freetown")},
        {QStringLiteral("Funafuti"), i18nc("This is a city associated with particular time zone", "Funafuti")},
        {QStringLiteral("Gaborone"), i18nc("This is a city associated with particular time zone", "Gaborone")},
        {QStringLiteral("Galapagos"), i18nc("This is a city associated with particular time zone", "Galapagos")},
        {QStringLiteral("Gambier"), i18nc("This is a city associated with particular time zone", "Gambier")},
        {QStringLiteral("Gaza"), i18nc("This is a city associated with particular time zone", "Gaza")},
        {QStringLiteral("Gibraltar"), i18nc("This is a city associated with particular time zone", "Gibraltar")},
        {QStringLiteral("Glace_Bay"), i18nc("This is a city associated with particular time zone", "Glace Bay")},
        {QStringLiteral("Godthab"), i18nc("This is a city associated with particular time zone", "Godthab")},
        {QStringLiteral("Goose_Bay"), i18nc("This is a city associated with particular time zone", "Goose Bay")},
        {QStringLiteral("Grand_Turk"), i18nc("This is a city associated with particular time zone", "Grand Turk")},
        {QStringLiteral("Grenada"), i18nc("This is a city associated with particular time zone", "Grenada")},
        {QStringLiteral("Guadalcanal"), i18nc("This is a city associated with particular time zone", "Guadalcanal")},
        {QStringLiteral("Guadeloupe"), i18nc("This is a city associated with particular time zone", "Guadeloupe")},
        {QStringLiteral("Guam"), i18nc("This is a city associated with particular time zone", "Guam")},
        {QStringLiteral("Guatemala"), i18nc("This is a city associated with particular time zone", "Guatemala")},
        {QStringLiteral("Guayaquil"), i18nc("This is a city associated with particular time zone", "Guayaquil")},
        {QStringLiteral("Guernsey"), i18nc("This is a city associated with particular time zone", "Guernsey")},
        {QStringLiteral("Guyana"), i18nc("This is a city associated with particular time zone", "Guyana")},
        {QStringLiteral("Halifax"), i18nc("This is a city associated with particular time zone", "Halifax")},
        {QStringLiteral("Harare"), i18nc("This is a city associated with particular time zone", "Harare")},
        {QStringLiteral("Harbin"), i18nc("This is a city associated with particular time zone", "Harbin")},
        {QStringLiteral("Havana"), i18nc("This is a city associated with particular time zone", "Havana")},
        {QStringLiteral("Hebron"), i18nc("This is a city associated with particular time zone", "Hebron")},
        {QStringLiteral("Helsinki"), i18nc("This is a city associated with particular time zone", "Helsinki")},
        {QStringLiteral("Hermosillo"), i18nc("This is a city associated with particular time zone", "Hermosillo")},
        {QStringLiteral("Ho_Chi_Minh"), i18nc("This is a city associated with particular time zone", "Ho Chi Minh")},
        {QStringLiteral("Hobart"), i18nc("This is a city associated with particular time zone", "Hobart")},
        {QStringLiteral("Hong_Kong"), i18nc("This is a city associated with particular time zone", "Hong Kong")},
        {QStringLiteral("Honolulu"), i18nc("This is a city associated with particular time zone", "Honolulu")},
        {QStringLiteral("Hovd"), i18nc("This is a city associated with particular time zone", "Hovd")},
        {QStringLiteral("Indianapolis"), i18nc("This is a city associated with particular time zone", "Indianapolis")},
        {QStringLiteral("Inuvik"), i18nc("This is a city associated with particular time zone", "Inuvik")},
        {QStringLiteral("Iqaluit"), i18nc("This is a city associated with particular time zone", "Iqaluit")},
        {QStringLiteral("Irkutsk"), i18nc("This is a city associated with particular time zone", "Irkutsk")},
        {QStringLiteral("Isle_of_Man"), i18nc("This is a city associated with particular time zone", "Isle of Man")},
        {QStringLiteral("Istanbul"), i18nc("This is a city associated with particular time zone", "Istanbul")},
        {QStringLiteral("Jakarta"), i18nc("This is a city associated with particular time zone", "Jakarta")},
        {QStringLiteral("Jamaica"), i18nc("This is a city associated with particular time zone", "Jamaica")},
        {QStringLiteral("Jayapura"), i18nc("This is a city associated with particular time zone", "Jayapura")},
        {QStringLiteral("Jersey"), i18nc("This is a city associated with particular time zone", "Jersey")},
        {QStringLiteral("Jerusalem"), i18nc("This is a city associated with particular time zone", "Jerusalem")},
        {QStringLiteral("Johannesburg"), i18nc("This is a city associated with particular time zone", "Johannesburg")},
        {QStringLiteral("Johnston"), i18nc("This is a city associated with particular time zone", "Johnston")},
        {QStringLiteral("Juba"), i18nc("This is a city associated with particular time zone", "Juba")},
        {QStringLiteral("Jujuy"), i18nc("This is a city associated with particular time zone", "Jujuy")},
        {QStringLiteral("Juneau"), i18nc("This is a city associated with particular time zone", "Juneau")},
        {QStringLiteral("Kabul"), i18nc("This is a city associated with particular time zone", "Kabul")},
        {QStringLiteral("Kaliningrad"), i18nc("This is a city associated with particular time zone", "Kaliningrad")},
        {QStringLiteral("Kamchatka"), i18nc("This is a city associated with particular time zone", "Kamchatka")},
        {QStringLiteral("Kampala"), i18nc("This is a city associated with particular time zone", "Kampala")},
        {QStringLiteral("Karachi"), i18nc("This is a city associated with particular time zone", "Karachi")},
        {QStringLiteral("Kashgar"), i18nc("This is a city associated with particular time zone", "Kashgar")},
        {QStringLiteral("Kathmandu"), i18nc("This is a city associated with particular time zone", "Kathmandu")},
        {QStringLiteral("Kerguelen"), i18nc("This is a city associated with particular time zone", "Kerguelen")},
        {QStringLiteral("Khandyga"), i18nc("This is a city associated with particular time zone", "Khandyga")},
        {QStringLiteral("Khartoum"), i18nc("This is a city associated with particular time zone", "Khartoum")},
        {QStringLiteral("Kiev"), i18nc("This is a city associated with particular time zone", "Kiev")},
        {QStringLiteral("Kigali"), i18nc("This is a city associated with particular time zone", "Kigali")},
        {QStringLiteral("Kinshasa"), i18nc("This is a city associated with particular time zone", "Kinshasa")},
        {QStringLiteral("Kiritimati"), i18nc("This is a city associated with particular time zone", "Kiritimati")},
        {QStringLiteral("Knox"), i18nc("This is a city associated with particular time zone", "Knox")},
        {QStringLiteral("Kolkata"), i18nc("This is a city associated with particular time zone", "Kolkata")},
        {QStringLiteral("Kosrae"), i18nc("This is a city associated with particular time zone", "Kosrae")},
        {QStringLiteral("Kralendijk"), i18nc("This is a city associated with particular time zone", "Kralendijk")},
        {QStringLiteral("Krasnoyarsk"), i18nc("This is a city associated with particular time zone", "Krasnoyarsk")},
        {QStringLiteral("Kuala_Lumpur"), i18nc("This is a city associated with particular time zone", "Kuala Lumpur")},
        {QStringLiteral("Kuching"), i18nc("This is a city associated with particular time zone", "Kuching")},
        {QStringLiteral("Kuwait"), i18nc("This is a city associated with particular time zone", "Kuwait")},
        {QStringLiteral("Kwajalein"), i18nc("This is a city associated with particular time zone", "Kwajalein")},
        {QStringLiteral("La_Paz"), i18nc("This is a city associated with particular time zone", "La Paz")},
        {QStringLiteral("La_Rioja"), i18nc("This is a city associated with particular time zone", "La Rioja")},
        {QStringLiteral("Lagos"), i18nc("This is a city associated with particular time zone", "Lagos")},
        {QStringLiteral("Libreville"), i18nc("This is a city associated with particular time zone", "Libreville")},
        {QStringLiteral("Lima"), i18nc("This is a city associated with particular time zone", "Lima")},
        {QStringLiteral("Lindeman"), i18nc("This is a city associated with particular time zone", "Lindeman")},
        {QStringLiteral("Lisbon"), i18nc("This is a city associated with particular time zone", "Lisbon")},
        {QStringLiteral("Ljubljana"), i18nc("This is a city associated with particular time zone", "Ljubljana")},
        {QStringLiteral("Lome"), i18nc("This is a city associated with particular time zone", "Lome")},
        {QStringLiteral("London"), i18nc("This is a city associated with particular time zone", "London")},
        {QStringLiteral("Longyearbyen"), i18nc("This is a city associated with particular time zone", "Longyearbyen")},
        {QStringLiteral("Lord_Howe"), i18nc("This is a city associated with particular time zone", "Lord Howe")},
        {QStringLiteral("Los_Angeles"), i18nc("This is a city associated with particular time zone", "Los Angeles")},
        {QStringLiteral("Louisville"), i18nc("This is a city associated with particular time zone", "Louisville")},
        {QStringLiteral("Lower_Princes"), i18nc("This is a city associated with particular time zone", "Lower Princes")},
        {QStringLiteral("Luanda"), i18nc("This is a city associated with particular time zone", "Luanda")},
        {QStringLiteral("Lubumbashi"), i18nc("This is a city associated with particular time zone", "Lubumbashi")},
        {QStringLiteral("Lusaka"), i18nc("This is a city associated with particular time zone", "Lusaka")},
        {QStringLiteral("Luxembourg"), i18nc("This is a city associated with particular time zone", "Luxembourg")},
        {QStringLiteral("Macau"), i18nc("This is a city associated with particular time zone", "Macau")},
        {QStringLiteral("Maceio"), i18nc("This is a city associated with particular time zone", "Maceio")},
        {QStringLiteral("Macquarie"), i18nc("This is a city associated with particular time zone", "Macquarie")},
        {QStringLiteral("Madeira"), i18nc("This is a city associated with particular time zone", "Madeira")},
        {QStringLiteral("Madrid"), i18nc("This is a city associated with particular time zone", "Madrid")},
        {QStringLiteral("Magadan"), i18nc("This is a city associated with particular time zone", "Magadan")},
        {QStringLiteral("Mahe"), i18nc("This is a city associated with particular time zone", "Mahe")},
        {QStringLiteral("Majuro"), i18nc("This is a city associated with particular time zone", "Majuro")},
        {QStringLiteral("Makassar"), i18nc("This is a city associated with particular time zone", "Makassar")},
        {QStringLiteral("Malabo"), i18nc("This is a city associated with particular time zone", "Malabo")},
        {QStringLiteral("Maldives"), i18nc("This is a city associated with particular time zone", "Maldives")},
        {QStringLiteral("Malta"), i18nc("This is a city associated with particular time zone", "Malta")},
        {QStringLiteral("Managua"), i18nc("This is a city associated with particular time zone", "Managua")},
        {QStringLiteral("Manaus"), i18nc("This is a city associated with particular time zone", "Manaus")},
        {QStringLiteral("Manila"), i18nc("This is a city associated with particular time zone", "Manila")},
        {QStringLiteral("Maputo"), i18nc("This is a city associated with particular time zone", "Maputo")},
        {QStringLiteral("Marengo"), i18nc("This is a city associated with particular time zone", "Marengo")},
        {QStringLiteral("Mariehamn"), i18nc("This is a city associated with particular time zone", "Mariehamn")},
        {QStringLiteral("Marigot"), i18nc("This is a city associated with particular time zone", "Marigot")},
        {QStringLiteral("Marquesas"), i18nc("This is a city associated with particular time zone", "Marquesas")},
        {QStringLiteral("Martinique"), i18nc("This is a city associated with particular time zone", "Martinique")},
        {QStringLiteral("Maseru"), i18nc("This is a city associated with particular time zone", "Maseru")},
        {QStringLiteral("Matamoros"), i18nc("This is a city associated with particular time zone", "Matamoros")},
        {QStringLiteral("Mauritius"), i18nc("This is a city associated with particular time zone", "Mauritius")},
        {QStringLiteral("Mawson"), i18nc("This is a city associated with particular time zone", "Mawson")},
        {QStringLiteral("Mayotte"), i18nc("This is a city associated with particular time zone", "Mayotte")},
        {QStringLiteral("Mazatlan"), i18nc("This is a city associated with particular time zone", "Mazatlan")},
        {QStringLiteral("Mbabane"), i18nc("This is a city associated with particular time zone", "Mbabane")},
        {QStringLiteral("McMurdo"), i18nc("This is a city associated with particular time zone", "McMurdo")},
        {QStringLiteral("Melbourne"), i18nc("This is a city associated with particular time zone", "Melbourne")},
        {QStringLiteral("Mendoza"), i18nc("This is a city associated with particular time zone", "Mendoza")},
        {QStringLiteral("Menominee"), i18nc("This is a city associated with particular time zone", "Menominee")},
        {QStringLiteral("Merida"), i18nc("This is a city associated with particular time zone", "Merida")},
        {QStringLiteral("Metlakatla"), i18nc("This is a city associated with particular time zone", "Metlakatla")},
        {QStringLiteral("Mexico_City"), i18nc("This is a city associated with particular time zone", "Mexico City")},
        {QStringLiteral("Midway"), i18nc("This is a city associated with particular time zone", "Midway")},
        {QStringLiteral("Minsk"), i18nc("This is a city associated with particular time zone", "Minsk")},
        {QStringLiteral("Miquelon"), i18nc("This is a city associated with particular time zone", "Miquelon")},
        {QStringLiteral("Mogadishu"), i18nc("This is a city associated with particular time zone", "Mogadishu")},
        {QStringLiteral("Monaco"), i18nc("This is a city associated with particular time zone", "Monaco")},
        {QStringLiteral("Moncton"), i18nc("This is a city associated with particular time zone", "Moncton")},
        {QStringLiteral("Monrovia"), i18nc("This is a city associated with particular time zone", "Monrovia")},
        {QStringLiteral("Monterrey"), i18nc("This is a city associated with particular time zone", "Monterrey")},
        {QStringLiteral("Montevideo"), i18nc("This is a city associated with particular time zone", "Montevideo")},
        {QStringLiteral("Monticello"), i18nc("This is a city associated with particular time zone", "Monticello")},
        {QStringLiteral("Montserrat"), i18nc("This is a city associated with particular time zone", "Montserrat")},
        {QStringLiteral("Moscow"), i18nc("This is a city associated with particular time zone", "Moscow")},
        {QStringLiteral("Muscat"), i18nc("This is a city associated with particular time zone", "Muscat")},
        {QStringLiteral("Nairobi"), i18nc("This is a city associated with particular time zone", "Nairobi")},
        {QStringLiteral("Nassau"), i18nc("This is a city associated with particular time zone", "Nassau")},
        {QStringLiteral("Nauru"), i18nc("This is a city associated with particular time zone", "Nauru")},
        {QStringLiteral("Ndjamena"), i18nc("This is a city associated with particular time zone", "Ndjamena")},
        {QStringLiteral("New_Salem"), i18nc("This is a city associated with particular time zone", "New Salem")},
        {QStringLiteral("New_York"), i18nc("This is a city associated with particular time zone", "New York")},
        {QStringLiteral("Niamey"), i18nc("This is a city associated with particular time zone", "Niamey")},
        {QStringLiteral("Nicosia"), i18nc("This is a city associated with particular time zone", "Nicosia")},
        {QStringLiteral("Nipigon"), i18nc("This is a city associated with particular time zone", "Nipigon")},
        {QStringLiteral("Niue"), i18nc("This is a city associated with particular time zone", "Niue")},
        {QStringLiteral("Nome"), i18nc("This is a city associated with particular time zone", "Nome")},
        {QStringLiteral("Norfolk"), i18nc("This is a city associated with particular time zone", "Norfolk")},
        {QStringLiteral("Noronha"), i18nc("This is a city associated with particular time zone", "Noronha")},
        {QStringLiteral("Nouakchott"), i18nc("This is a city associated with particular time zone", "Nouakchott")},
        {QStringLiteral("Noumea"), i18nc("This is a city associated with particular time zone", "Noumea")},
        {QStringLiteral("Novokuznetsk"), i18nc("This is a city associated with particular time zone", "Novokuznetsk")},
        {QStringLiteral("Novosibirsk"), i18nc("This is a city associated with particular time zone", "Novosibirsk")},
        {QStringLiteral("Ojinaga"), i18nc("This is a city associated with particular time zone", "Ojinaga")},
        {QStringLiteral("Omsk"), i18nc("This is a city associated with particular time zone", "Omsk")},
        {QStringLiteral("Oral"), i18nc("This is a city associated with particular time zone", "Oral")},
        {QStringLiteral("Oslo"), i18nc("This is a city associated with particular time zone", "Oslo")},
        {QStringLiteral("Ouagadougou"), i18nc("This is a city associated with particular time zone", "Ouagadougou")},
        {QStringLiteral("Pago_Pago"), i18nc("This is a city associated with particular time zone", "Pago Pago")},
        {QStringLiteral("Palau"), i18nc("This is a city associated with particular time zone", "Palau")},
        {QStringLiteral("Palmer"), i18nc("This is a city associated with particular time zone", "Palmer")},
        {QStringLiteral("Panama"), i18nc("This is a city associated with particular time zone", "Panama")},
        {QStringLiteral("Pangnirtung"), i18nc("This is a city associated with particular time zone", "Pangnirtung")},
        {QStringLiteral("Paramaribo"), i18nc("This is a city associated with particular time zone", "Paramaribo")},
        {QStringLiteral("Paris"), i18nc("This is a city associated with particular time zone", "Paris")},
        {QStringLiteral("Perth"), i18nc("This is a city associated with particular time zone", "Perth")},
        {QStringLiteral("Petersburg"), i18nc("This is a city associated with particular time zone", "Petersburg")},
        {QStringLiteral("Phnom_Penh"), i18nc("This is a city associated with particular time zone", "Phnom Penh")},
        {QStringLiteral("Phoenix"), i18nc("This is a city associated with particular time zone", "Phoenix")},
        {QStringLiteral("Pitcairn"), i18nc("This is a city associated with particular time zone", "Pitcairn")},
        {QStringLiteral("Podgorica"), i18nc("This is a city associated with particular time zone", "Podgorica")},
        {QStringLiteral("Pohnpei"), i18nc("This is a city associated with particular time zone", "Pohnpei")},
        {QStringLiteral("Pontianak"), i18nc("This is a city associated with particular time zone", "Pontianak")},
        {QStringLiteral("Port-au-Prince"), i18nc("This is a city associated with particular time zone", "Port-au-Prince")},
        {QStringLiteral("Port_Moresby"), i18nc("This is a city associated with particular time zone", "Port Moresby")},
        {QStringLiteral("Port_of_Spain"), i18nc("This is a city associated with particular time zone", "Port of Spain")},
        {QStringLiteral("Porto-Novo"), i18nc("This is a city associated with particular time zone", "Porto-Novo")},
        {QStringLiteral("Porto_Velho"), i18nc("This is a city associated with particular time zone", "Porto Velho")},
        {QStringLiteral("Prague"), i18nc("This is a city associated with particular time zone", "Prague")},
        {QStringLiteral("Puerto_Rico"), i18nc("This is a city associated with particular time zone", "Puerto Rico")},
        {QStringLiteral("Pyongyang"), i18nc("This is a city associated with particular time zone", "Pyongyang")},
        {QStringLiteral("Qatar"), i18nc("This is a city associated with particular time zone", "Qatar")},
        {QStringLiteral("Qyzylorda"), i18nc("This is a city associated with particular time zone", "Qyzylorda")},
        {QStringLiteral("Rainy_River"), i18nc("This is a city associated with particular time zone", "Rainy River")},
        {QStringLiteral("Rangoon"), i18nc("This is a city associated with particular time zone", "Rangoon")},
        {QStringLiteral("Rankin_Inlet"), i18nc("This is a city associated with particular time zone", "Rankin Inlet")},
        {QStringLiteral("Rarotonga"), i18nc("This is a city associated with particular time zone", "Rarotonga")},
        {QStringLiteral("Recife"), i18nc("This is a city associated with particular time zone", "Recife")},
        {QStringLiteral("Regina"), i18nc("This is a city associated with particular time zone", "Regina")},
        {QStringLiteral("Resolute"), i18nc("This is a city associated with particular time zone", "Resolute")},
        {QStringLiteral("Reunion"), i18nc("This is a city associated with particular time zone", "Reunion")},
        {QStringLiteral("Reykjavik"), i18nc("This is a city associated with particular time zone", "Reykjavik")},
        {QStringLiteral("Riga"), i18nc("This is a city associated with particular time zone", "Riga")},
        {QStringLiteral("Rio_Branco"), i18nc("This is a city associated with particular time zone", "Rio Branco")},
        {QStringLiteral("Rio_Gallegos"), i18nc("This is a city associated with particular time zone", "Rio Gallegos")},
        {QStringLiteral("Riyadh"), i18nc("This is a city associated with particular time zone", "Riyadh")},
        {QStringLiteral("Rome"), i18nc("This is a city associated with particular time zone", "Rome")},
        {QStringLiteral("Rothera"), i18nc("This is a city associated with particular time zone", "Rothera")},
        {QStringLiteral("Saipan"), i18nc("This is a city associated with particular time zone", "Saipan")},
        {QStringLiteral("Sakhalin"), i18nc("This is a city associated with particular time zone", "Sakhalin")},
        {QStringLiteral("Salta"), i18nc("This is a city associated with particular time zone", "Salta")},
        {QStringLiteral("Samara"), i18nc("This is a city associated with particular time zone", "Samara")},
        {QStringLiteral("Samarkand"), i18nc("This is a city associated with particular time zone", "Samarkand")},
        {QStringLiteral("San_Juan"), i18nc("This is a city associated with particular time zone", "San Juan")},
        {QStringLiteral("San_Luis"), i18nc("This is a city associated with particular time zone", "San Luis")},
        {QStringLiteral("San_Marino"), i18nc("This is a city associated with particular time zone", "San Marino")},
        {QStringLiteral("Santa_Isabel"), i18nc("This is a city associated with particular time zone", "Santa Isabel")},
        {QStringLiteral("Santarem"), i18nc("This is a city associated with particular time zone", "Santarem")},
        {QStringLiteral("Santiago"), i18nc("This is a city associated with particular time zone", "Santiago")},
        {QStringLiteral("Santo_Domingo"), i18nc("This is a city associated with particular time zone", "Santo Domingo")},
        {QStringLiteral("Sao_Paulo"), i18nc("This is a city associated with particular time zone", "Sao Paulo")},
        {QStringLiteral("Sao_Tome"), i18nc("This is a city associated with particular time zone", "Sao Tome")},
        {QStringLiteral("Sarajevo"), i18nc("This is a city associated with particular time zone", "Sarajevo")},
        {QStringLiteral("Scoresbysund"), i18nc("This is a city associated with particular time zone", "Scoresbysund")},
        {QStringLiteral("Seoul"), i18nc("This is a city associated with particular time zone", "Seoul")},
        {QStringLiteral("Shanghai"), i18nc("This is a city associated with particular time zone", "Shanghai")},
        {QStringLiteral("Simferopol"), i18nc("This is a city associated with particular time zone", "Simferopol")},
        {QStringLiteral("Singapore"), i18nc("This is a city associated with particular time zone", "Singapore")},
        {QStringLiteral("Sitka"), i18nc("This is a city associated with particular time zone", "Sitka")},
        {QStringLiteral("Skopje"), i18nc("This is a city associated with particular time zone", "Skopje")},
        {QStringLiteral("Sofia"), i18nc("This is a city associated with particular time zone", "Sofia")},
        {QStringLiteral("South_Georgia"), i18nc("This is a city associated with particular time zone", "South Georgia")},
        {QStringLiteral("St_Barthelemy"), i18nc("This is a city associated with particular time zone", "St Barthelemy")},
        {QStringLiteral("St_Helena"), i18nc("This is a city associated with particular time zone", "St Helena")},
        {QStringLiteral("St_Johns"), i18nc("This is a city associated with particular time zone", "St Johns")},
        {QStringLiteral("St_Kitts"), i18nc("This is a city associated with particular time zone", "St Kitts")},
        {QStringLiteral("St_Lucia"), i18nc("This is a city associated with particular time zone", "St Lucia")},
        {QStringLiteral("St_Thomas"), i18nc("This is a city associated with particular time zone", "St Thomas")},
        {QStringLiteral("St_Vincent"), i18nc("This is a city associated with particular time zone", "St Vincent")},
        {QStringLiteral("Stanley"), i18nc("This is a city associated with particular time zone", "Stanley")},
        {QStringLiteral("Stockholm"), i18nc("This is a city associated with particular time zone", "Stockholm")},
        {QStringLiteral("Swift_Current"), i18nc("This is a city associated with particular time zone", "Swift Current")},
        {QStringLiteral("Sydney"), i18nc("This is a city associated with particular time zone", "Sydney")},
        {QStringLiteral("Syowa"), i18nc("This is a city associated with particular time zone", "Syowa")},
        {QStringLiteral("Tahiti"), i18nc("This is a city associated with particular time zone", "Tahiti")},
        {QStringLiteral("Taipei"), i18nc("This is a city associated with particular time zone", "Taipei")},
        {QStringLiteral("Tallinn"), i18nc("This is a city associated with particular time zone", "Tallinn")},
        {QStringLiteral("Tarawa"), i18nc("This is a city associated with particular time zone", "Tarawa")},
        {QStringLiteral("Tashkent"), i18nc("This is a city associated with particular time zone", "Tashkent")},
        {QStringLiteral("Tbilisi"), i18nc("This is a city associated with particular time zone", "Tbilisi")},
        {QStringLiteral("Tegucigalpa"), i18nc("This is a city associated with particular time zone", "Tegucigalpa")},
        {QStringLiteral("Tehran"), i18nc("This is a city associated with particular time zone", "Tehran")},
        {QStringLiteral("Tell_City"), i18nc("This is a city associated with particular time zone", "Tell City")},
        {QStringLiteral("Thimphu"), i18nc("This is a city associated with particular time zone", "Thimphu")},
        {QStringLiteral("Thule"), i18nc("This is a city associated with particular time zone", "Thule")},
        {QStringLiteral("Thunder_Bay"), i18nc("This is a city associated with particular time zone", "Thunder Bay")},
        {QStringLiteral("Tijuana"), i18nc("This is a city associated with particular time zone", "Tijuana")},
        {QStringLiteral("Tirane"), i18nc("This is a city associated with particular time zone", "Tirane")},
        {QStringLiteral("Tokyo"), i18nc("This is a city associated with particular time zone", "Tokyo")},
        {QStringLiteral("Tongatapu"), i18nc("This is a city associated with particular time zone", "Tongatapu")},
        {QStringLiteral("Toronto"), i18nc("This is a city associated with particular time zone", "Toronto")},
        {QStringLiteral("Tortola"), i18nc("This is a city associated with particular time zone", "Tortola")},
        {QStringLiteral("Tripoli"), i18nc("This is a city associated with particular time zone", "Tripoli")},
        {QStringLiteral("Troll"), i18nc("This is a city associated with particular time zone", "Troll")},
        {QStringLiteral("Tucuman"), i18nc("This is a city associated with particular time zone", "Tucuman")},
        {QStringLiteral("Tunis"), i18nc("This is a city associated with particular time zone", "Tunis")},
        {QStringLiteral("Ulaanbaatar"), i18nc("This is a city associated with particular time zone", "Ulaanbaatar")},
        {QStringLiteral("Urumqi"), i18nc("This is a city associated with particular time zone", "Urumqi")},
        {QStringLiteral("Ushuaia"), i18nc("This is a city associated with particular time zone", "Ushuaia")},
        {QStringLiteral("Ust-Nera"), i18nc("This is a city associated with particular time zone", "Ust-Nera")},
        {QStringLiteral("UTC+00:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+00:00")},
        {QStringLiteral("UTC+01:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+01:00")},
        {QStringLiteral("UTC+02:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+02:00")},
        {QStringLiteral("UTC+03:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+03:00")},
        {QStringLiteral("UTC+03:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+03:30")},
        {QStringLiteral("UTC+04:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+04:00")},
        {QStringLiteral("UTC+04:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+04:30")},
        {QStringLiteral("UTC+05:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+05:00")},
        {QStringLiteral("UTC+05:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+05:30")},
        {QStringLiteral("UTC+05:45"), i18nc("This is a generic time zone name, localize as needed", "UTC+05:45")},
        {QStringLiteral("UTC+06:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+06:00")},
        {QStringLiteral("UTC+06:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+06:30")},
        {QStringLiteral("UTC+07:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+07:00")},
        {QStringLiteral("UTC+08:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+08:00")},
        {QStringLiteral("UTC+09:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+09:00")},
        {QStringLiteral("UTC+09:30"), i18nc("This is a generic time zone name, localize as needed", "UTC+09:30")},
        {QStringLiteral("UTC+10:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+10:00")},
        {QStringLiteral("UTC+11:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+11:00")},
        {QStringLiteral("UTC+12:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+12:00")},
        {QStringLiteral("UTC+13:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+13:00")},
        {QStringLiteral("UTC+14:00"), i18nc("This is a generic time zone name, localize as needed", "UTC+14:00")},
        {QStringLiteral("UTC-00:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-00:00")},
        {QStringLiteral("UTC-01:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-01:00")},
        {QStringLiteral("UTC-02:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-02:00")},
        {QStringLiteral("UTC-03:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-03:00")},
        {QStringLiteral("UTC-03:30"), i18nc("This is a generic time zone name, localize as needed", "UTC-03:30")},
        {QStringLiteral("UTC-04:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-04:00")},
        {QStringLiteral("UTC-04:30"), i18nc("This is a generic time zone name, localize as needed", "UTC-04:30")},
        {QStringLiteral("UTC-05:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-05:00")},
        {QStringLiteral("UTC-06:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-06:00")},
        {QStringLiteral("UTC-07:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-07:00")},
        {QStringLiteral("UTC-08:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-08:00")},
        {QStringLiteral("UTC-09:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-09:00")},
        {QStringLiteral("UTC-10:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-10:00")},
        {QStringLiteral("UTC-11:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-11:00")},
        {QStringLiteral("UTC-12:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-12:00")},
        {QStringLiteral("UTC-13:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-13:00")},
        {QStringLiteral("UTC-14:00"), i18nc("This is a generic time zone name, localize as needed", "UTC-14:00")},
        {QStringLiteral("UTC"), i18nc("This is a generic time zone name, localize as needed", "UTC")},
        {QStringLiteral("Uzhgorod"), i18nc("This is a city associated with particular time zone", "Uzhgorod")},
        {QStringLiteral("Vaduz"), i18nc("This is a city associated with particular time zone", "Vaduz")},
        {QStringLiteral("Vancouver"), i18nc("This is a city associated with particular time zone", "Vancouver")},
        {QStringLiteral("Vatican"), i18nc("This is a city associated with particular time zone", "Vatican")},
        {QStringLiteral("Vevay"), i18nc("This is a city associated with particular time zone", "Vevay")},
        {QStringLiteral("Vienna"), i18nc("This is a city associated with particular time zone", "Vienna")},
        {QStringLiteral("Vientiane"), i18nc("This is a city associated with particular time zone", "Vientiane")},
        {QStringLiteral("Vilnius"), i18nc("This is a city associated with particular time zone", "Vilnius")},
        {QStringLiteral("Vincennes"), i18nc("This is a city associated with particular time zone", "Vincennes")},
        {QStringLiteral("Vladivostok"), i18nc("This is a city associated with particular time zone", "Vladivostok")},
        {QStringLiteral("Volgograd"), i18nc("This is a city associated with particular time zone", "Volgograd")},
        {QStringLiteral("Vostok"), i18nc("This is a city associated with particular time zone", "Vostok")},
        {QStringLiteral("Wake"), i18nc("This is a city associated with particular time zone", "Wake")},
        {QStringLiteral("Wallis"), i18nc("This is a city associated with particular time zone", "Wallis")},
        {QStringLiteral("Warsaw"), i18nc("This is a city associated with particular time zone", "Warsaw")},
        {QStringLiteral("Whitehorse"), i18nc("This is a city associated with particular time zone", "Whitehorse")},
        {QStringLiteral("Winamac"), i18nc("This is a city associated with particular time zone", "Winamac")},
        {QStringLiteral("Windhoek"), i18nc("This is a city associated with particular time zone", "Windhoek")},
        {QStringLiteral("Winnipeg"), i18nc("This is a city associated with particular time zone", "Winnipeg")},
        {QStringLiteral("Yakutat"), i18nc("This is a city associated with particular time zone", "Yakutat")},
        {QStringLiteral("Yakutsk"), i18nc("This is a city associated with particular time zone", "Yakutsk")},
        {QStringLiteral("Yekaterinburg"), i18nc("This is a city associated with particular time zone", "Yekaterinburg")},
        {QStringLiteral("Yellowknife"), i18nc("This is a city associated with particular time zone", "Yellowknife")},
        {QStringLiteral("Yerevan"), i18nc("This is a city associated with particular time zone", "Yerevan")},
        {QStringLiteral("Zagreb"), i18nc("This is a city associated with particular time zone", "Zagreb")},
        {QStringLiteral("Zaporozhye"), i18nc("This is a city associated with particular time zone", "Zaporozhye")},
        {QStringLiteral("Zurich"), i18nc("This is a city associated with particular time zone", "Zurich")}
    });

    m_i18nCountries = QHash<QLocale::Country, QString>({
        {QLocale::IvoryCoast,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Ivory Coast")},
        {QLocale::Ghana,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Ghana")},
        {QLocale::Ethiopia,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Ethiopia")},
        {QLocale::Algeria,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Algeria")},
        {QLocale::Eritrea,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Eritrea")},
        {QLocale::Mali,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Mali")},
        {QLocale::CentralAfricanRepublic,     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Central African Republic")},
        {QLocale::Gambia,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Gambia")},
        {QLocale::GuineaBissau,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Guinea Bissau")},
        {QLocale::Malawi,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Malawi")},
        {QLocale::CongoBrazzaville,           i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Congo Brazzaville")},
        {QLocale::Burundi,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Burundi")},
        {QLocale::Egypt,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Egypt")},
        {QLocale::Morocco,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Morocco")},
        {QLocale::Spain,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Spain")},
        {QLocale::Guinea,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Guinea")},
        {QLocale::Senegal,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Senegal")},
        {QLocale::Tanzania,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Tanzania")},
        {QLocale::Djibouti,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Djibouti")},
        {QLocale::Cameroon,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cameroon")},
        {QLocale::WesternSahara,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Western Sahara")},
        {QLocale::SierraLeone,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Sierra Leone")},
        {QLocale::Botswana,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Botswana")},
        {QLocale::Zimbabwe,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Zimbabwe")},
        {QLocale::SouthAfrica,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "South Africa")},
        {QLocale::SouthSudan,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "South Sudan")},
        {QLocale::Uganda,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Uganda")},
        {QLocale::Sudan,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Sudan")},
        {QLocale::Rwanda,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Rwanda")},
        {QLocale::CongoKinshasa,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Congo (Kinshasa)")},
        {QLocale::Nigeria,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Nigeria")},
        {QLocale::Gabon,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Gabon")},
        {QLocale::Togo,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Togo")},
        {QLocale::Angola,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Angola")},
        {QLocale::Zambia,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Zambia")},
        {QLocale::EquatorialGuinea,           i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Equatorial Guinea")},
        {QLocale::Mozambique,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Mozambique")},
        {QLocale::Lesotho,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Lesotho")},
        {QLocale::Swaziland,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Swaziland")},
        {QLocale::Somalia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Somalia")},
        {QLocale::Liberia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Liberia")},
        {QLocale::Kenya,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Kenya")},
        {QLocale::Chad,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Chad")},
        {QLocale::Niger,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Niger")},
        {QLocale::Mauritania,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Mauritania")},
        {QLocale::BurkinaFaso,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Burkina Faso")},
        {QLocale::Benin,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Benin")},
        {QLocale::SaoTomeAndPrincipe,         i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Sao Tome And Principe")},
        {QLocale::Libya,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Libya")},
        {QLocale::Tunisia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Tunisia")},
        {QLocale::Namibia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Namibia")},
        {QLocale::UnitedStates,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "United States")},
        {QLocale::Anguilla,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Anguilla")},
        {QLocale::AntiguaAndBarbuda,          i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Antigua And Barbuda")},
        {QLocale::Brazil,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Brazil")},
        {QLocale::Argentina,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Argentina")},
        {QLocale::Aruba,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Aruba")},
        {QLocale::Paraguay,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Paraguay")},
        {QLocale::Canada,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Canada")},
        {QLocale::Mexico,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Mexico")},
        {QLocale::Barbados,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Barbados")},
        {QLocale::Belize,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Belize")},
        {QLocale::Colombia,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Colombia")},
        {QLocale::Venezuela,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Venezuela")},
        {QLocale::FrenchGuiana,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "French Guiana")},
        {QLocale::CaymanIslands,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cayman Islands")},
        {QLocale::CostaRica,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Costa Rica")},
        {QLocale::CuraSao,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cura Sao")},
        {QLocale::Greenland,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Greenland")},
        {QLocale::Dominica,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Dominica")},
        {QLocale::ElSalvador,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "El Salvador")},
        {QLocale::TurksAndCaicosIslands,      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Turks And Caicos Islands")},
        {QLocale::Grenada,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Grenada")},
        {QLocale::Guadeloupe,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Guadeloupe")},
        {QLocale::Guatemala,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Guatemala")},
        {QLocale::Ecuador,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Ecuador")},
        {QLocale::Guyana,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Guyana")},
        {QLocale::Cuba,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cuba")},
        {QLocale::Jamaica,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Jamaica")},
        {QLocale::Bonaire,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bonaire")},
        {QLocale::Bolivia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bolivia")},
        {QLocale::Peru,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Peru")},
        {QLocale::SintMaarten,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Sint Maarten")},
        {QLocale::Nicaragua,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Nicaragua")},
        {QLocale::SaintMartin,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saint Martin")},
        {QLocale::Martinique,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Martinique")},
        {QLocale::SaintPierreAndMiquelon,     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saint Pierre And Miquelon")},
        {QLocale::Uruguay,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Uruguay")},
        {QLocale::Montserrat,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Montserrat")},
        {QLocale::Bahamas,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bahamas")},
        {QLocale::Panama,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Panama")},
        {QLocale::Suriname,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Suriname")},
        {QLocale::Haiti,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Haiti")},
        {QLocale::TrinidadAndTobago,          i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Trinidad And Tobago")},
        {QLocale::PuertoRico,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Puerto Rico")},
        {QLocale::Chile,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Chile")},
        {QLocale::DominicanRepublic,          i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Dominican Republic")},
        {QLocale::SaintBarthelemy,            i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saint Barthelemy")},
        {QLocale::SaintKittsAndNevis,         i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saint Kitts And Nevis")},
        {QLocale::SaintLucia,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saint Lucia")},
        {QLocale::UnitedStatesVirginIslands,  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "United States Virgin Islands")},
        {QLocale::SaintVincentAndTheGrenadines, i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saint Vincent And The Grenadines")},
        {QLocale::Honduras,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Honduras")},
        {QLocale::BritishVirginIslands,       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "British Virgin Islands")},
        {QLocale::Antarctica,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Antarctica")},
        {QLocale::Australia,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Australia")},
        {QLocale::SvalbardAndJanMayenIslands, i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Svalbard And Jan Mayen Islands")},
        {QLocale::Yemen,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Yemen")},
        {QLocale::Kazakhstan,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Kazakhstan")},
        {QLocale::Jordan,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Jordan")},
        {QLocale::Russia,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Russia")},
        {QLocale::Turkmenistan,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Turkmenistan")},
        {QLocale::Iraq,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Iraq")},
        {QLocale::Bahrain,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bahrain")},
        {QLocale::Azerbaijan,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Azerbaijan")},
        {QLocale::Thailand,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Thailand")},
        {QLocale::Lebanon,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Lebanon")},
        {QLocale::Kyrgyzstan,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Kyrgyzstan")},
        {QLocale::Brunei,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Brunei")},
        {QLocale::Mongolia,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Mongolia")},
        {QLocale::China,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "China")},
        {QLocale::SriLanka,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Sri Lanka")},
        {QLocale::Syria,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Syria")},
        {QLocale::Bangladesh,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bangladesh")},
        {QLocale::EastTimor,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "East Timor")},
        {QLocale::UnitedArabEmirates,         i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "United Arab Emirates")},
        {QLocale::Tajikistan,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Tajikistan")},
        {QLocale::PalestinianTerritories,     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Palestinian Territories")},
        {QLocale::Vietnam,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Vietnam")},
        {QLocale::HongKong,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Hong Kong")},
        {QLocale::Indonesia,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Indonesia")},
        {QLocale::Israel,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Israel")},
        {QLocale::Afghanistan,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Afghanistan")},
        {QLocale::Pakistan,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Pakistan")},
        {QLocale::Nepal,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Nepal")},
        {QLocale::India,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "India")},
        {QLocale::Malaysia,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Malaysia")},
        {QLocale::Kuwait,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Kuwait")},
        {QLocale::Macau,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Macau")},
        {QLocale::Philippines,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Philippines")},
        {QLocale::Oman,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Oman")},
        {QLocale::Cyprus,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cyprus")},
        {QLocale::Cambodia,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cambodia")},
        {QLocale::NorthKorea,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "North Korea")},
        {QLocale::Qatar,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Qatar")},
        {QLocale::Myanmar,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Myanmar")},
        {QLocale::SaudiArabia,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saudi Arabia")},
        {QLocale::Uzbekistan,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Uzbekistan")},
        {QLocale::SouthKorea,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "South Korea")},
        {QLocale::Singapore,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Singapore")},
        {QLocale::Taiwan,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Taiwan")},
        {QLocale::Georgia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Georgia")},
        {QLocale::Iran,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Iran")},
        {QLocale::Bhutan,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bhutan")},
        {QLocale::Japan,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Japan")},
        {QLocale::Laos,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Laos")},
        {QLocale::Armenia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Armenia")},
        {QLocale::Portugal,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Portugal")},
        {QLocale::Bermuda,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bermuda")},
        {QLocale::CapeVerde,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cape Verde")},
        {QLocale::FaroeIslands,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Faroe Islands")},
        {QLocale::Iceland,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Iceland")},
        {QLocale::SouthGeorgiaAndTheSouthSandwichIslands, i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "South Georgia And The South Sandwich Islands")},
        {QLocale::SaintHelena,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Saint Helena")},
        {QLocale::FalklandIslands,            i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Falkland Islands")},
        {QLocale::Netherlands,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Netherlands")},
        {QLocale::Andorra,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Andorra")},
        {QLocale::Greece,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Greece")},
        {QLocale::Serbia,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Serbia")},
        {QLocale::Germany,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Germany")},
        {QLocale::Slovakia,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Slovakia")},
        {QLocale::Belgium,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Belgium")},
        {QLocale::Romania,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Romania")},
        {QLocale::Hungary,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Hungary")},
        {QLocale::Moldova,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Moldova")},
        {QLocale::Denmark,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Denmark")},
        {QLocale::Ireland,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Ireland")},
        {QLocale::Gibraltar,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Gibraltar")},
        {QLocale::Guernsey,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Guernsey")},
        {QLocale::Finland,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Finland")},
        {QLocale::IsleOfMan,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Isle Of Man")},
        {QLocale::Turkey,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Turkey")},
        {QLocale::Jersey,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Jersey")},
        {QLocale::Ukraine,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Ukraine")},
        {QLocale::Slovenia,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Slovenia")},
        {QLocale::UnitedKingdom,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "United Kingdom")},
        {QLocale::Luxembourg,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Luxembourg")},
        {QLocale::Malta,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Malta")},
        {QLocale::AlandIslands,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Aland Islands")},
        {QLocale::Belarus,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Belarus")},
        {QLocale::Monaco,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Monaco")},
        {QLocale::Norway,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Norway")},
        {QLocale::France,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "France")},
        {QLocale::Montenegro,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Montenegro")},
        {QLocale::CzechRepublic,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Czech Republic")},
        {QLocale::Latvia,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Latvia")},
        {QLocale::Italy,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Italy")},
        {QLocale::SanMarino,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "San Marino")},
        {QLocale::BosniaAndHerzegowina,       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bosnia And Herzegowina")},
        {QLocale::Macedonia,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Macedonia")},
        {QLocale::Bulgaria,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Bulgaria")},
        {QLocale::Sweden,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Sweden")},
        {QLocale::Estonia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Estonia")},
        {QLocale::Albania,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Albania")},
        {QLocale::Liechtenstein,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Liechtenstein")},
        {QLocale::VaticanCityState,           i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Vatican City State")},
        {QLocale::Austria,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Austria")},
        {QLocale::Lithuania,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Lithuania")},
        {QLocale::Poland,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Poland")},
        {QLocale::Croatia,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Croatia")},
        {QLocale::Switzerland,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Switzerland")},
        {QLocale::Madagascar,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Madagascar")},
        {QLocale::BritishIndianOceanTerritory, i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "British Indian Ocean Territory")},
        {QLocale::ChristmasIsland,            i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "ChristmasIsland")},
        {QLocale::CocosIslands,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "CocosIslands")},
        {QLocale::Comoros,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Comoros")},
        {QLocale::FrenchSouthernTerritories,  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "French Southern Territories")},
        {QLocale::Seychelles,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Seychelles")},
        {QLocale::Maldives,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Maldives")},
        {QLocale::Mauritius,                  i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Mauritius")},
        {QLocale::Mayotte,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Mayotte")},
        {QLocale::Reunion,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Reunion")},
        {QLocale::Samoa,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Samoa")},
        {QLocale::NewZealand,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "New Zealand")},
        {QLocale::Micronesia,                 i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Micronesia")},
        {QLocale::Vanuatu,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Vanuatu")},
        {QLocale::Kiribati,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Kiribati")},
        {QLocale::Tokelau,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Tokelau")},
        {QLocale::Fiji,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Fiji")},
        {QLocale::Tuvalu,                     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Tuvalu")},
        {QLocale::FrenchPolynesia,            i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "French Polynesia")},
        {QLocale::SolomonIslands,             i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Solomon Islands")},
        {QLocale::Guam,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Guam")},
        {QLocale::UnitedStatesMinorOutlyingIslands, i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "United States Minor Outlying Islands")},
        {QLocale::MarshallIslands,            i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Marshall Islands")},
        {QLocale::NauruCountry,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Nauru")},
        {QLocale::Niue,                       i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Niue")},
        {QLocale::NorfolkIsland,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Norfolk Island")},
        {QLocale::NewCaledonia,               i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "New Caledonia")},
        {QLocale::AmericanSamoa,              i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "American Samoa")},
        {QLocale::Palau,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Palau")},
        {QLocale::Pitcairn,                   i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Pitcairn")},
        {QLocale::PapuaNewGuinea,             i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Papua New Guinea")},
        {QLocale::CookIslands,                i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Cook Islands")},
        {QLocale::NorthernMarianaIslands,     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Northern Mariana Islands")},
        {QLocale::Tonga,                      i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Tonga")},
        {QLocale::WallisAndFutunaIslands,     i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Wallis And Futuna Islands")} });
        //           {QLocale::Default,                    i18nc("This is a country name associated with a particular time zone in a zone selection dialog", "Default")} },

    m_i18nContinents = QHash<QString, QString>({
        {QStringLiteral("Africa"),     i18nc("This is a continent/area associated with a particular timezone", "Africa")},
        {QStringLiteral("America"),    i18nc("This is a continent/area associated with a particular timezone", "America")},
        {QStringLiteral("Antarctica"), i18nc("This is a continent/area associated with a particular timezone", "Antarctica")},
        {QStringLiteral("Asia"),       i18nc("This is a continent/area associated with a particular timezone", "Asia")},
        {QStringLiteral("Atlantic"),   i18nc("This is a continent/area associated with a particular timezone", "Atlantic")},
        {QStringLiteral("Australia"),  i18nc("This is a continent/area associated with a particular timezone", "Australia")},
        {QStringLiteral("Europe"),     i18nc("This is a continent/area associated with a particular timezone", "Europe")},
        {QStringLiteral("Indian"),     i18nc("This is a continent/area associated with a particular timezone", "Indian")},
        {QStringLiteral("Pacific"),    i18nc("This is a continent/area associated with a particular timezone", "Pacific")}
    });

    m_isInitialized = true;
}
