/*****************************************************************************
 * PokerTH - The open source texas holdem engine                             *
 * Copyright (C) 2006-2012 Felix Hammer, Florian Thauer, Lothar May          *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU Affero General Public License as            *
 * published by the Free Software Foundation, either version 3 of the        *
 * License, or (at your option) any later version.                           *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU Affero General Public License for more details.                       *
 *                                                                           *
 * You should have received a copy of the GNU Affero General Public License  *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 *                                                                           *
 * Additional permission under GNU AGPL version 3 section 7                  *
 *                                                                           *
 * If you modify this program, or any covered work, by linking or            *
 * combining it with the OpenSSL project's OpenSSL library (or a             *
 * modified version of that library), containing parts covered by the        *
 * terms of the OpenSSL or SSLeay licenses, the authors of PokerTH           *
 * (Felix Hammer, Florian Thauer, Lothar May) grant you additional           *
 * permission to convey the resulting work.                                  *
 * Corresponding Source for a non-source form of such a combination          *
 * shall include the source code for the parts of OpenSSL used as well       *
 * as that of the covered work.                                              *
 *****************************************************************************/

#include <boost/asio.hpp>
#include <net/clientcontext.h>


ClientContext::ClientContext()
	: m_sctp(false), m_addrFamily(AF_INET), m_useServerList(false), m_serverPort(0),
	  m_playerRights(PLAYER_RIGHTS_NORMAL), m_hasSubscribedLobbyMsg(true)
{
}

ClientContext::~ClientContext()
{
	m_sessionData.reset();
}

boost::shared_ptr<SessionData>
ClientContext::GetSessionData() const
{
	return m_sessionData;
}

void
ClientContext::SetSessionData(boost::shared_ptr<SessionData> sessionData)
{
	m_sessionData = sessionData;
}

boost::shared_ptr<boost::asio::ip::tcp::resolver>
ClientContext::GetResolver() const
{
	return m_resolver;
}

void
ClientContext::SetResolver(boost::shared_ptr<boost::asio::ip::tcp::resolver> resolver)
{
	m_resolver = resolver;
}

