# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class RelayServiceConnectionEntity(Resource):
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource Name.
    :type name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Resource Location.
    :type location: str
    :param type: Resource type.
    :type type: str
    :param tags: Resource tags.
    :type tags: dict
    :param entity_name:
    :type entity_name: str
    :param entity_connection_string:
    :type entity_connection_string: str
    :param resource_type:
    :type resource_type: str
    :param resource_connection_string:
    :type resource_connection_string: str
    :param hostname:
    :type hostname: str
    :param port:
    :type port: int
    :param biztalk_uri:
    :type biztalk_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'entity_name': {'key': 'properties.entityName', 'type': 'str'},
        'entity_connection_string': {'key': 'properties.entityConnectionString', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'resource_connection_string': {'key': 'properties.resourceConnectionString', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'biztalk_uri': {'key': 'properties.biztalkUri', 'type': 'str'},
    }

    def __init__(self, location, name=None, kind=None, type=None, tags=None, entity_name=None, entity_connection_string=None, resource_type=None, resource_connection_string=None, hostname=None, port=None, biztalk_uri=None):
        super(RelayServiceConnectionEntity, self).__init__(name=name, kind=kind, location=location, type=type, tags=tags)
        self.entity_name = entity_name
        self.entity_connection_string = entity_connection_string
        self.resource_type = resource_type
        self.resource_connection_string = resource_connection_string
        self.hostname = hostname
        self.port = port
        self.biztalk_uri = biztalk_uri
