/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;

class DiagramDisplay
extends Canvas {
    KansBoom editor;

    DiagramDisplay(KansBoom kansBoom, Font font, float f, Color color, Color color2, Font font2) {
        this.editor = kansBoom;
        this.setBackground(KansBoom.bgcolor);
        this.resize(KansBoom.xsize, KansBoom.ysize);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(KansBoom.penfont);
        graphics2D.setStroke(new BasicStroke(KansBoom.thickness));
        graphics2D.setColor(KansBoom.drawcolor);
        Enumeration enumeration = this.editor.diagram.elements();
        while (enumeration.hasMoreElements()) {
            ((DiagramItem)enumeration.nextElement()).draw(graphics2D);
        }
    }

    @Override
    public boolean mouseDown(Event event, int n, int n2) {
        if (this.editor.current_event_consumer.down(n, n2)) {
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseUp(Event event, int n, int n2) {
        if (this.editor.current_event_consumer.up(n, n2)) {
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.editor.current_event_consumer.drag(n, n2)) {
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyDown(Event event, int n) {
        if (this.editor.current_event_consumer.key(n)) {
            this.repaint();
            return true;
        }
        return false;
    }
}

